/**
 * @author Dieter Kaeppel, Intersult GmbH
 * @date   13.11.2013
 */

if (ext == null) {
	var ext = {};
}

if (ext.push == null) {
	ext.push = {
		Channel: function(name) {
			this.name = name;
			this.source = null;
			this.url = null;
			this.logLevel = 'debug';
			this.transport = 'websocket';
			this.timeout = 0;
			this.reconnectInterval = 30000;
			this.maxReconnectOnClose = Number.MAX_VALUE;
			this.fallbackTransport = 'long-polling';
			this.autoConnect = true;
			this.socket = null;
			this.openHandlers = [];
			this.closeHandlers = [];
			this.messageHandlers = [];
			this.errorHandlers = [];
			this.onOpen = function(response) {ext.push.invoke(this.openHandlers, this, response);};
			this.onReopen = function(response) {ext.push.invoke(this.openHandlers, this, response);};
			this.onClose = function(response) {ext.push.invoke(this.closeHandlers, this, response);};
			this.onMessage = function(response) {ext.push.invoke(this.messageHandlers, this, response);};
			this.onError = function(response) {ext.push.invoke(this.errorHandlers, this, response);};
		},
		
		channels: {},
		
		invoke: function(handlers, channel, response) {
			for (var i = 0; i < handlers.length; ++i) {
				handlers[i](channel, response);
			}
		},
		applyAjax: function(channel, response) {
			jsf.ajax.request(channel.source, event, {
				'javax.faces.behavior.event': 'push',
				render: response.responseBody
			});
		},
		applyChanges: function(channel, response) {
			var xml = ext.ajax.parseXml(response.responseBody);
			var changes = ext.ajax.getChanges(xml);
			ext.ajax.sendEvent(response.responseBody, xml, response.status, "complete");
			ext.ajax.applyChanges(changes);
			ext.ajax.sendEvent(response.responseBody, xml, response.status, "success");
		},
		openChannel: function(baseUrl, name, source, direct) {
			var channel = ext.push.getChannel(name);
			if (channel.socket == null) {
				channel.source = source;
				channel.url = baseUrl + name + '?ln=push';
				channel.socket = atmosphere.subscribe(channel);
				if (direct) {
					channel.messageHandlers.push(ext.push.applyChanges);
				} else {
					channel.messageHandlers.push(ext.push.applyAjax);
				}
				ext.util.addNodeRemoveListener(source, function() {
					ext.push.closeChannel(name);
				});
			}
			return channel;
		},
		getChannel: function(name) {
			var channel = ext.push.channels[name];
			if (channel == null) {
				channel = new ext.push.Channel(name);
				ext.push.channels[name] = channel;
			}
			return channel;
		},
		closeChannel: function(name) {
			var channel = ext.push.channels[name];
			if (channel == null)
				return;
			atmosphere.unsubscribeUrl(channel.url);
			channel.socket = null;
			delete ext.push.channels[name];
		}
	};
}