if (ext == null) {
	var ext = {};
}

if (ext.primefaces == null) {
	ext.primefaces = {
		init: function(element) {
			if (typeof element.getElementsByTagName == 'undefined')
				return;
			var inputs = element.getElementsByTagName("input");
			for (var i = 0; i < inputs.length; ++i) {
				var input = inputs[i];
				if (typeof input.classNameBase == 'undefined') {
					if (input.type === 'submit' || input.type === 'button') {
						input.classNameBase = input.className +
							" ui-button ui-widget ui-state-default ui-corner-all ui-button-text-only ui-button-text";
						if (input.disabled)
							input.classNameBase += " ui-state-disabled";
						input.className = input.classNameBase;
						ext.primefaces.addMouse(input);
						ext.primefaces.addFocus(input);
					} else if (input.type === 'text' || input.type === 'password') {
						input.classNameBase = input.className +
							" ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
						if (input.disabled)
							input.classNameBase += " ui-state-disabled";
						input.className = input.classNameBase;
						ext.primefaces.addFocus(input);
					}
				}
			}
			inputs = element.getElementsByTagName("select");
			for (var i = 0; i < inputs.length; ++i) {
				var input = inputs[i];
				if (typeof input.classNameBase == 'undefined') {
					input.classNameBase = input.className +
						" ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
					if (input.disabled)
						input.classNameBase += " ui-state-disabled";
					input.className = input.classNameBase;
					ext.primefaces.addFocus(input);
				}
			}
			inputs = element.getElementsByTagName("textarea");
			for (var i = 0; i < inputs.length; ++i) {
				var input = inputs[i];
				if (typeof input.classNameBase == 'undefined') {
					input.classNameBase = input.className +
						" ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
					if (input.disabled)
						input.classNameBase += " ui-state-disabled";
					input.className = input.classNameBase;
					ext.primefaces.addFocus(input);
				}
			}
		},
		
		addMouse: function(input) {
			ext.util.addListener(input, "mouseover", ext.primefaces.onmouseover);
			ext.util.addListener(input, "mouseout", ext.primefaces.onmouseout);
		},

		addFocus: function(input) {
			ext.util.addListener(input, "blur", ext.primefaces.onblur);
			ext.util.addListener(input, "focus", ext.primefaces.onfocus);
		},
		
		onmouseout: function(event) {
			var element = event.target || event.srcElement;
			element.hovered = false;
			ext.primefaces.update(element);
		},
		
		onmouseover: function(event) {
			var element = event.target || event.srcElement;
			element.hovered = true;
			ext.primefaces.update(element);
		},
		
		onblur: function(event) {
			var element = event.target || event.srcElement;
			element.focused = false;
			ext.primefaces.update(element);
		},
		
		onfocus: function(event) {
			var element = event.target || event.srcElement;
			element.focused = true;
			ext.primefaces.update(element);
		},
		
		update: function(element) {
			var className = element.classNameBase;
			if (element.hovered)
				className += " ui-state-hover";
			if (element.focused)
				className += " ui-state-focus";
			element.className = className;
		}
	};
	
	ext.util.addNodeInsertListener(ext.primefaces.init);
}