/**
 * @author Dieter Kaeppel, Intersult GmbH
 * @date   09-10.2012
 */

if (ext == null) {
	var ext = {};
}

if (ext.ajax == null) {
	ext.ajax = {
		viewStateName: "javax.faces.ViewState",
		viewStateId: "j_id1:javax.faces.ViewState:0",
        viewStateRegex: new RegExp("javax.faces.ViewState:.*$"),
		isIECache: null,
        isAutoExecCache: null,
			
		test: function(x) {
			alert(x);
		},

		/**
		 * Fix problems with missing view states when refreshing element that embedds a form.
		 */
		addViewState: function(data) {
			try {
				if (data.status == 'complete') {
					var changes = ext.ajax.getChanges(data.responseXML);
					for (var i = 0; i < changes.length; ++i) {
						if ("extension" == changes[i].nodeName && changes[i].getAttribute('ln') === "ext" &&
								changes[i].getAttribute('type') === "head") {
							var html = ext.ajax.entityDecode(changes[i].childNodes[0].nodeValue);
							ext.ajax.addHeader(html);
						}
					}
				} else if (data.status == 'success') {
					var changes = ext.ajax.getChanges(data.responseXML);
					var render = [];
					for (var i = 0; i < changes.length; ++i) {
						var id = changes[i].getAttribute('id');
						if ("update" == changes[i].nodeName && id != null && !id.match(ext.ajax.viewStateRegex))
							render[render.length] = id;
						if ("insert" == changes[i].nodeName)
							render[render.length] = changes[i].firstChild.getAttribute('insertId');
					}
					var viewState = null;
					for (var i = 0; i < changes.length; ++i) {
						var id = changes[i].getAttribute('id');
						if ("update" == changes[i].nodeName && id != null && id.match(ext.ajax.viewStateRegex)) {
							viewState = changes[i].firstChild.nodeValue;
							ext.ajax.updateViewState(viewState, render, true);
						}
					}
					if (viewState == null) {
						viewState = ext.ajax.getViewState();
                        if (viewState != null)
                        	ext.ajax.updateViewState(viewState, render, false);
					}
				}
			} catch (ex) {
				if (typeof console != 'undefined')
					console.error(ex.stack);
			}
		},
		getViewState: function() {
			var element = document.getElementById('j_id1:javax.faces.ViewState:0');
			if (element == null)
				return null;
			return element.value;
		},
		
		addHeader: function(str) {
			var findTags = /<[^>]+(\/>|><\/[^>]+>)/gm;
		    var head = document.getElementsByTagName('head')[0] || document.documentElement;
			var tags = str.match(findTags);
			while (tags.length > 0) {
				var element = ext.ajax.parseElement(tags.shift());
				if (element.tagName == 'SCRIPT') {
					var script = ext.ajax.loadScript(element.src);
					ext.ajax.globalEval(script);
				} else {
					head.appendChild(element);
				}
			}
		},
		entityDecode: function(encoded) {
			var div = document.createElement("div");
			var result = encoded;
			if (typeof div.innerHTML != "undefined" && typeof div.firstChild != "undefined") {
				result = encoded.replace(/&[a-z0-9#]+;/gi,
					function(a) {
						div.innerHTML = a;
						return div.firstChild.nodeValue;
					}
				);
			}
			return result;
		},
		parseElement: function(str) {
			var findTag = /<(\S+)([^>]*)(\/>|><\/[^>]+>)/m;
			var findAttributes = /\s+?\S+=("[^"]*"|'[^']*')/gm;
			var findAttribute = /\s+?(\S+)=("([^"]*)"|'([^']*)')/m;
			var tag = str.match(findTag);
			var element = document.createElement(tag[1]);
			var attributes = tag[2].match(findAttributes);
			while (attributes.length > 0) {
				var attribute = attributes.shift().match(findAttribute);
				element.setAttribute(attribute[1], attribute[3] || attribute[4]);
			}
		    return element;
		},
		loadScript: function(url) {
            var xhr = ext.ajax.getTransport();
            if (xhr === null)
                return "";

            xhr.open("GET", url, false);
            xhr.setRequestHeader("Content-Type", "application/x-javascript");
            xhr.send(null);

            if (xhr.readyState == 4 && xhr.status == 200)
            	return xhr.responseText;
            return "";
		},
        runScripts: function runScripts(scripts) {
            if (!scripts || scripts.length === 0)
                return;
            while (scripts.length) {
            	ext.ajax.runScript(scripts.shift());
            }
        },
        runScript: function(script) {
            if (!script || script == '')
                return;
            var head = document.getElementsByTagName('head')[0] || document.documentElement;
            var scriptNode = document.createElement('script');
            scriptNode.type = 'text/javascript';
            scriptNode.text = script;
            head.appendChild(scriptNode);
            head.removeChild(scriptNode);
        },
        getTransport: function() {
            var methods = [
                function() {
                    return new XMLHttpRequest();
                },
                function() {
                    return new ActiveXObject('Msxml2.XMLHTTP');
                },
                function() {
                    return new ActiveXObject('Microsoft.XMLHTTP');
                }
            ];

            var returnVal;
            for (var i = 0, len = methods.length; i < len; i++) {
                try {
                    returnVal = methods[i]();
                } catch(e) {
                    continue;
                }
                return returnVal;
            }
            throw new Error('Could not create an XHR object.');
        },
        globalEval: function(src) {
            if (window.execScript) {
                window.execScript(src);
            } else {
                var fn = function() {
                    window.eval.call(window,src);
                };
                fn();
            }
        },
		applyChanges: function(changes) {
            try {
                for (var i = 0; i < changes.length; i++) {
                    switch (changes[i].nodeName) {
                        case "update":
                            ext.ajax.applyUpdate(changes[i]);
                            break;
                        case "delete":
                        	ext.ajax.applyDelete(changes[i]);
                            break;
                        case "insert":
                        	ext.ajax.applyInsert(changes[i]);
                            break;
                        case "attributes":
                        	ext.ajax.applyAttributes(changes[i]);
                            break;
                        case "eval":
                        	ext.ajax.applyEval(changes[i]);
                            break;
                        case "extension":
                            // no action
                            break;
                        default:
                            alert("Changes allowed are: update, delete, insert, attributes, eval, extension. Received "
                            	+ changes[i].nodeName + " instead.");
                            return;
                    }
                }
            } catch (ex) {
                alert(ex.message);
                return;
            }
		},
		applyUpdate: function(element) {
			var id = element.getAttribute('id');
			var d = document.getElementById(id);
			if (d == null)
				throw new Error("During update: " + id + " not found");
			
            var src = '';
            for (var j = 0; j < element.childNodes.length; j++) {
                content = element.childNodes[j];
                src += content.nodeValue;
            }
            var parent = d.parentNode;
            var html = src.replace(/^\s+/g, '').replace(/\s+$/g, '');
            var parserElement = document.createElement('div');
            var tag = d.nodeName.toLowerCase();
            var tableElements = ['td', 'th', 'tr', 'tbody', 'thead', 'tfoot'];
            var isInTable = false;
            for (var tei = 0, tel = tableElements.length; tei < tel; tei++) {
                if (tableElements[tei] == tag) {
                    isInTable = true;
                    break;
                }
            }
            if (isInTable) {
                if (ext.ajax.isAutoExec()) {
                    parserElement.innerHTML = '<table>' + html + '</table>';
                } else {
                    scripts = ext.ajax.stripScripts(html);
                    html = html.replace(/<script[^>]*type="text\/javascript"*>([\S\s]*?)<\/script>/igm,"");
                    parserElement.innerHTML = '<table>' + html + '</table>';
                }
                var newElement = parserElement.firstChild;
                while ((null !== newElement) && (id !== newElement.id)) {
                    newElement = newElement.firstChild;
                }
                parent.replaceChild(newElement, d);
                ext.ajax.runScripts(scripts);
            } else if (d.nodeName.toLowerCase() === 'input') {
                parserElement = document.createElement('div');
                parserElement.innerHTML = html;
                newElement = parserElement.firstChild;

                ext.ajax.cloneAttributes(d, newElement);
                ext.ajax.deleteNode(parserElement);
            } else if (html.length > 0) {
                if (ext.ajax.isAutoExec()) {
                    parserElement.innerHTML = html;
                } else {
                    scripts = ext.ajax.stripScripts(html);
                    html = html.replace(/<script[^>]*type="text\/javascript"*>([\S\s]*?)<\/script>/igm,"");
                    parserElement.innerHTML = html;
                }
                ext.ajax.replaceNode(parserElement.firstChild, d);
                ext.ajax.deleteNode(parserElement);
                ext.ajax.runScripts(scripts);
            }
		},
		applyDelete: function(element) {
			// TODO
		},
		applyInsert: function(element) {
			// TODO
		},
		applyAttributes: function(element) {
			// TODO
		},
		applyEval: function(element) {
            var evalText = element.firstChild.nodeValue;
            ext.ajax.globalEval(evalText);
		},
        replaceNode: function replaceNode(newNode, node) {
            if (ext.ajax.isIE()) {
                 node.parentNode.insertBefore(newNode, node);
                 deleteNode(node);
            } else {
                 node.parentNode.replaceChild(newNode, node);
            }
        },
        deleteNode: function deleteNode(node) {
            if (!node || !node.parentNode)
                return;
            if (!isIE() || isIE9Plus()) {
                node.parentNode.removeChild(node);
                return;
            }
            if (node.nodeName.toLowerCase() === "body") {
                ext.ajax.deleteChildren(node);
                try {
                    node.outerHTML = '';
                } catch (ex) {
                }
                return;
            }
            var temp = node.ownerDocument.createElement('div');
            var parent = node.parentNode;
            temp.appendChild(parent.removeChild(node));
            try {
                temp.outerHTML = ''; //prevent leak in IE
            } catch (ex) {
            }
        },
        deleteChildren: function deleteChildren(node) {
            if (!node)
                return;
            for (var x = node.childNodes.length - 1; x >= 0; x--) {
                var childNode = node.childNodes[x];
                deleteNode(childNode);
            }
        },
        stripScripts: function stripScripts(str) {
            var findscripts = /<script[^>]*>([\S\s]*?)<\/script>/igm;
            var findscript = /<script([^>]*)>([\S\s]*?)<\/script>/im;
            var stripStart = /^\s*(<!--)*\s*(\/\/)*\s*(\/\*)*\s*\n*\**\n*\s*\*.*\n*\s*\*\/(<!\[CDATA\[)*/;
            var findsrc = /src="([\S]*?)"/im;
            var findtype = /type="([\S]*?)"/im;
            var scripts = [];
            var initialnodes = str.match(findscripts);
            while (!!initialnodes && initialnodes.length > 0) {
                var scriptStr = [];
                scriptStr = initialnodes.shift().match(findscript);
                var type = [];
                type = scriptStr[1].match(findtype);
                if ( !!type && type[1]) {
                    if (type[1] !== "text/javascript")
                        continue;
                }
                var src = [];
                src = scriptStr[1].match(findsrc);
                var script;
                if ( !!src && src[1]) {
                    var url = src[1];
                    if (/\/javax.faces.resource\/jsf.js\?ln=javax\.faces/.test(url)) {
                        script = false;
                    } else {
                        script = loadScript(url);
                    }
                } else if (!!scriptStr && scriptStr[2]){
                    script = scriptStr[2].replace(stripStart,"");
                } else {
                    script = false;
                }
                if (!!script)
                    scripts.push(script);
            }
            return scripts;
        },
        isIE: function isIE() {
            if (typeof ext.ajax.isIECache !== "undefined")
                return ext.ajax.isIECache;
            ext.ajax.isIECache = document.all && window.ActiveXObject &&
               navigator.userAgent.toLowerCase().indexOf("msie") > -1 &&
               navigator.userAgent.toLowerCase().indexOf("opera") == -1;
            return ext.ajax.isIECache;
        },
        isIE9Plus: function isIE9Plus() {
            return typeof XDomainRequest !== "undefined" && typeof window.msPerformance !== "undefined";
        },
        isAutoExec: function isAutoExec() {
        	if (ext.ajax.isAutoExecCache != null)
        		return ext.ajax.isAutoExecCache;
            try {
                var autoExecTestString = "<script>var mojarra = mojarra || {};mojarra.autoExecTest = true;</script>";
                var tempElement = document.createElement('span');
                tempElement.innerHTML = autoExecTestString;
                var body = document.getElementsByTagName('body')[0];
                var tempNode = body.appendChild(tempElement);
                if (mojarra && mojarra.autoExecTest) {
                	ext.ajax.isAutoExecCache = true;
                    delete mojarra.autoExecTest;
                } else {
                	ext.ajax.isAutoExecCache = false;
                }
                deleteNode(tempNode);
                return ext.ajax.isAutoExecCache;
            } catch (ex) {
                if (ext.ajax.isAutoExecCache == null)
                	ext.ajax.isAutoExecCache = false;
                return ext.ajax.isAutoExecCache;
            }
        },
		parseXml: function(xmlText) {
			var parseXml;

			if (typeof window.DOMParser != "undefined") {
				parseXml = function(xmlStr) {
			        return ( new window.DOMParser() ).parseFromString(xmlStr, "text/xml");
			    };
			} else if (typeof window.ActiveXObject != "undefined" &&
			       new window.ActiveXObject("Microsoft.XMLDOM")) {
			    parseXml = function(xmlStr) {
			        var xmlDoc = new window.ActiveXObject("Microsoft.XMLDOM");
			        xmlDoc.async = "false";
			        xmlDoc.loadXML(xmlStr);
			        return xmlDoc;
			    };
			} else {
			    throw new Error("No XML parser found");
			}
			
			return parseXml(xmlText);
		},
		getChanges: function(xml) {
			if (xml == null)
				return [];
			var partialResponse = xml.getElementsByTagName("partial-response");
			if (partialResponse == null || partialResponse.length == 0)
				return [];
			var responseType = partialResponse[0].firstChild;
			if (responseType.nodeName !== "changes")
				return [];
			return responseType.childNodes;
		},
		sendEvent: function(text, xml, responseCode, status) {
            var data = {};
            data.type = "event";
            data.status = status;
            data.responseCode = responseCode;
            data.responseXML = xml;
            data.responseText = text;
            jsf.ajax.invokeEventListeners(data);
		},
		
		updateViewState: function(viewState, render, override) {
			for (var i = 0; i < render.length; ++i) {
				for (var j = 0; j < document.forms.length; ++j) {
					var form = document.forms[j];
					if (ext.ajax.parentOf(form, render[i])) {
						var field = form.elements[ext.ajax.viewStateId];
						if (typeof field === 'undefined') {
							field = document.createElement("input");
							field.type = "hidden";
							field.name = ext.ajax.viewStateName;
							field.id = ext.ajax.viewStateId;
							field.value = viewState;
							form.appendChild(field);
						} else if (override) {
							field.value = viewState;
						}
					}
				}
			}
		},
		
		parentOf: function(element, id) {
			if (element != null && id != null && "" != id) {
				if (element.id != null && element.id != id && element.id.indexOf(id + ':') == 0)
					return true;
				var contentId = id + '_content';
				for (var test = element; test != null; test = test.parentNode) {
					if (test.id === id || test.id === contentId)
						return true;
				}
			}
			return false;
		}
	};

	jsf.ajax.addOnEvent(ext.ajax.addViewState);
}