/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.view;

import com.intersult.jsf.extensions.ExtPartialResponseWriter;
import com.intersult.jsf.view.ExtVisitCallback;
import java.io.IOException;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class RenderVisitCallback
extends ExtVisitCallback {
    private Collection<String> renderIds;
    private Collection<String> appendIds;
    private Collection<String> deleteIds;

    public RenderVisitCallback(Collection<String> renderIds, Collection<String> appendIds, Collection<String> deleteIds) {
        this.renderIds = renderIds;
        this.appendIds = appendIds;
        this.deleteIds = deleteIds;
        this.addPrefixes(renderIds);
        this.addPrefixes(appendIds);
        this.addPrefixes(deleteIds);
    }

    public VisitResult visit(VisitContext visitContext, UIComponent target) {
        FacesContext context = visitContext.getFacesContext();
        String clientId = target.getClientId(context);
        try {
            if (!this.testClientId(context, target)) {
                return VisitResult.REJECT;
            }
            if (this.deleteIds.contains(clientId)) {
                return VisitResult.REJECT;
            }
            if (this.appendIds.contains(clientId)) {
                ExtPartialResponseWriter writer = (ExtPartialResponseWriter)context.getResponseWriter();
                String parentId = target.getParent().getClientId(context);
                writer.startInsert(parentId, clientId, "append");
                target.encodeAll(context);
                writer.endInsert();
                return VisitResult.REJECT;
            }
            if (this.renderIds.contains(clientId)) {
                ExtPartialResponseWriter writer = (ExtPartialResponseWriter)context.getResponseWriter();
                writer.startUpdate(target.getClientId(context));
                target.encodeAll(context);
                writer.endUpdate();
                return VisitResult.REJECT;
            }
        }
        catch (IOException exception) {
            throw new FacesException("Error rendering component type " + target.getClass().getName() + " with id '" + clientId + "'", (Throwable)exception);
        }
        return VisitResult.ACCEPT;
    }
}

