/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.view;

import com.intersult.jsf.extensions.ExtPartialResponseWriter;
import com.intersult.jsf.view.RenderVisitCallback;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.PartialViewContextWrapper;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.ClientWindow;

public class ExtPartialViewContext
extends PartialViewContextWrapper {
    private static final String ORIGINAL_WRITER = "com.sun.faces.ORIGINAL_WRITER";
    private PartialViewContext wrapped;
    private ExtPartialResponseWriter writer;
    private List<String> evalBeforeList = new ArrayList<String>();
    private List<String> evalAfterList = new ArrayList<String>();
    private List<String> appendIds = new ArrayList<String>();
    private List<String> deleteIds = new ArrayList<String>();

    public ExtPartialViewContext(PartialViewContext wrapped) {
        this.wrapped = wrapped;
        FacesContext context = FacesContext.getCurrentInstance();
        context.getAttributes().put(ExtPartialViewContext.class.getName(), this);
    }

    public static ExtPartialViewContext instance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return (ExtPartialViewContext)((Object)context.getAttributes().get(ExtPartialViewContext.class.getName()));
    }

    public PartialViewContext getWrapped() {
        return this.wrapped;
    }

    public void setPartialRequest(boolean partialRequest) {
        this.wrapped.setPartialRequest(partialRequest);
    }

    public void processPartial(PhaseId phaseId) {
        if (!(phaseId != PhaseId.RENDER_RESPONSE || this.wrapped.isRenderAll() || this.appendIds.isEmpty() && this.deleteIds.isEmpty())) {
            this.processRenderPartial();
        } else {
            this.wrapped.processPartial(phaseId);
        }
    }

    public void processRenderPartial() {
        FacesContext context = FacesContext.getCurrentInstance();
        Collection renderIds = this.getRenderIds();
        UIViewRoot viewRoot = context.getViewRoot();
        try {
            ExtPartialResponseWriter writer = this.getPartialResponseWriter();
            ResponseWriter orig = context.getResponseWriter();
            context.getAttributes().put(ORIGINAL_WRITER, orig);
            context.setResponseWriter((ResponseWriter)writer);
            ExternalContext exContext = context.getExternalContext();
            exContext.setResponseContentType("text/xml");
            exContext.addResponseHeader("Cache-Control", "no-cache");
            String encoding = writer.getCharacterEncoding();
            if (encoding == null) {
                encoding = "UTF-8";
            }
            writer.writePreamble("<?xml version='1.0' encoding='" + encoding + "'?>\n");
            writer.startDocument();
            if (this.isResetValues()) {
                viewRoot.resetValues(context, renderIds);
            }
            if (renderIds != null && !renderIds.isEmpty() || !this.appendIds.isEmpty() || !this.deleteIds.isEmpty()) {
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED, VisitHint.EXECUTE_LIFECYCLE);
                VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context, null, hints);
                RenderVisitCallback visitCallback = new RenderVisitCallback(renderIds, this.appendIds, this.deleteIds);
                viewRoot.visitTree(visitContext, (VisitCallback)visitCallback);
                for (String deleteId : this.deleteIds) {
                    writer.delete(deleteId);
                }
            }
            this.renderState(context);
            writer.endDocument();
        }
        catch (IOException exception) {
            this.cleanupAfterView(context);
        }
        catch (RuntimeException exception) {
            this.cleanupAfterView(context);
            throw exception;
        }
    }

    public void renderState(FacesContext context) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        String viewStateId = Util.getViewStateId((FacesContext)context);
        writer.startUpdate(viewStateId);
        String state = context.getApplication().getStateManager().getViewState(context);
        writer.write(state);
        writer.endUpdate();
        ClientWindow window = context.getExternalContext().getClientWindow();
        if (null != window) {
            String clientWindowId = Util.getClientWindowId((FacesContext)context);
            writer.startUpdate(clientWindowId);
            writer.write(window.getId());
            writer.endUpdate();
        }
    }

    public void cleanupAfterView(FacesContext context) {
        ResponseWriter orig = (ResponseWriter)context.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        context.setResponseWriter(orig);
    }

    public ExtPartialResponseWriter getPartialResponseWriter() {
        if (this.writer == null) {
            this.writer = new ExtPartialResponseWriter(this.wrapped.getPartialResponseWriter());
        }
        return this.writer;
    }

    public void evalBefore(String script) {
        if (script != null && !"".equals(script)) {
            this.evalBeforeList.add(script);
        }
    }

    public List<String> getEvalBefore() {
        return this.evalBeforeList;
    }

    public void evalAfter(String script) {
        if (script != null && !"".equals(script)) {
            this.evalAfterList.add(script);
        }
    }

    public List<String> getEvalAfter() {
        return this.evalAfterList;
    }

    public Collection<String> getAppendIds() {
        return this.appendIds;
    }

    public List<String> getDeleteIds() {
        return this.deleteIds;
    }
}

