/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.validator;

import com.intersult.jpa.HibernateHelper;
import com.intersult.jsf.el.ExpressionAnalyzer;
import com.intersult.jsf.el.ValueReference;
import com.intersult.jsf.error.ValidatorResourceException;
import com.intersult.jsf.util.java.ClassUtils;
import java.io.Serializable;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metadata.ClassMetadata;

@FacesValidator(value="intersult.Unique")
public class UniqueValidator
implements Validator {
    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        UniqueValidatorAdapter.validate(context, component, value);
    }

    public static class UniqueValidatorAdapter {
        public static void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
            ValueExpression expression = component.getValueExpression("value");
            if (expression == null) {
                return;
            }
            ValueReference reference = ExpressionAnalyzer.getReference(expression, context.getELContext());
            Session session = (Session)HibernateHelper.instance().getEntityManager().getDelegate();
            Class<?> entityClass = ClassUtils.unproxy(reference.getBaseClass());
            Criteria criteria = session.createCriteria(entityClass);
            ClassMetadata classMetadata = session.getSessionFactory().getClassMetadata(entityClass);
            Serializable id = classMetadata.getIdentifier(reference.getBase(), (SessionImplementor)session);
            if (id != null) {
                criteria.add(Restrictions.not((Criterion)Restrictions.idEq((Object)id)));
            }
            criteria.add((Criterion)Restrictions.eq((String)((String)reference.getProperty()), (Object)value));
            criteria.setMaxResults(1);
            Object result = criteria.uniqueResult();
            if (result != null) {
                throw new ValidatorResourceException("unique.error", new Object[0]);
            }
        }
    }
}

