/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;
import org.springframework.core.io.ResourceLoader;

public class ApplicationServletContext
implements ServletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private static final Logger logger = Logger.getLogger(ApplicationServletContext.class);
    private final String resourceBasePath;
    private String contextPath = "";
    private int majorVersion = 2;
    private int minorVersion = 5;
    private int effectiveMajorVersion = 2;
    private int effectiveMinorVersion = 5;
    private final Map<String, ServletContext> contexts = new HashMap<String, ServletContext>();
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private String servletContextName = "MockServletContext";
    private final Set<String> declaredRoles = new HashSet<String>();

    public ApplicationServletContext() {
        this("", null);
    }

    public ApplicationServletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public ApplicationServletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public ApplicationServletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return this.resourceBasePath + path;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath != null ? contextPath : "";
    }

    public ServletContext getContext(String contextPath) {
        if (this.contextPath.equals(contextPath)) {
            return this;
        }
        return this.contexts.get(contextPath);
    }

    public void registerContext(String contextPath, ServletContext context) {
        this.contexts.put(contextPath, context);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getEffectiveMajorVersion() {
        return this.effectiveMajorVersion;
    }

    public void setEffectiveMajorVersion(int effectiveMajorVersion) {
        this.effectiveMajorVersion = effectiveMajorVersion;
    }

    public int getEffectiveMinorVersion() {
        return this.effectiveMinorVersion;
    }

    public void setEffectiveMinorVersion(int effectiveMinorVersion) {
        this.effectiveMinorVersion = effectiveMinorVersion;
    }

    public String getMimeType(String filePath) {
        return MimeTypeResolver.getMimeType(filePath);
    }

    public Set<String> getResourcePaths(String path) {
        String actualPath = path.endsWith("/") ? path : path + "/";
        try {
            File file = new File(actualPath);
            File[] fileList = file.listFiles();
            if (fileList == null || fileList.length == 0) {
                return null;
            }
            LinkedHashSet<String> resourcePaths = new LinkedHashSet<String>(fileList.length);
            for (File fileEntry : fileList) {
                if (fileEntry.isDirectory()) {
                    resourcePaths.add(fileEntry.getAbsolutePath() + "/");
                    continue;
                }
                resourcePaths.add(fileEntry.getAbsolutePath());
            }
            return resourcePaths;
        }
        catch (Exception exception) {
            logger.warn((Object)("Error getting resources paths for '" + path + "'"), (Throwable)exception);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getClass().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getClass().getResourceAsStream(path);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("RequestDispatcher path at ServletContext level must start with '/'");
        }
        return new RequestDispatcher(){

            public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }

            public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            }
        };
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration<Servlet> getServlets() {
        return Collections.enumeration(new HashSet());
    }

    public Enumeration<String> getServletNames() {
        return Collections.enumeration(new HashSet());
    }

    public void log(String message) {
        logger.info((Object)message);
    }

    public void log(Exception ex, String message) {
        logger.info((Object)message, (Throwable)ex);
    }

    public void log(String message, Throwable ex) {
        logger.info((Object)message, ex);
    }

    public String getRealPath(String path) {
        return this.getClass().getResource(path).getFile();
    }

    public String getServerInfo() {
        return this.getClass().getSimpleName();
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        if (this.initParameters.containsKey(name)) {
            return false;
        }
        this.initParameters.put(name, value);
        return true;
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributes.keySet()).elements();
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    public Set<String> getDeclaredRoles() {
        return Collections.unmodifiableSet(this.declaredRoles);
    }

    public void declareRoles(String ... roleNames) {
        for (String roleName : roleNames) {
            this.declaredRoles.add(roleName);
        }
    }

    private static class MimeTypeResolver {
        private MimeTypeResolver() {
        }

        public static String getMimeType(String filePath) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(filePath);
        }
    }
}

