/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.java;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.aop.framework.Advised;

public class ClassUtils {
    public static final String JAVASSIST_PROXY = "javassist.util.proxy.ProxyObject";
    private static Boolean spring;
    private static boolean skipSpring;

    public static Class<?> getTypeParameter(Class<?> type, int index) {
        Type genericSuperclass = type.getGenericSuperclass();
        Type actualTypeArgument = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[0];
        if (actualTypeArgument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)actualTypeArgument).getRawType();
        }
        return (Class)actualTypeArgument;
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error instantiating class '" + type.getName() + "'", exception);
        }
    }

    public static <T> T instantiate(Class<T> type, Object ... params) {
        Class<?>[] paramTypes = ClassUtils.getTypes(params);
        try {
            Constructor<T> constructor = type.getConstructor(paramTypes);
            return constructor.newInstance(params);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error instantiating class '" + type.getName() + "'", exception);
        }
    }

    public static Class<?>[] getTypes(Object[] params) {
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = ClassUtils.getType(params[i]);
        }
        return paramTypes;
    }

    public static Class<? extends Object> getType(Object object) {
        return object == null ? Object.class : object.getClass();
    }

    public static Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> type) {
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors = Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                map.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        catch (IntrospectionException exception) {
            throw new RuntimeException(exception);
        }
        return map;
    }

    public static boolean isSpring() {
        if (spring == null) {
            try {
                Class.forName("org.springframework.core.SpringVersion");
                spring = Boolean.TRUE;
            }
            catch (Throwable exception) {
                spring = Boolean.FALSE;
            }
        }
        return spring;
    }

    public static Object unproxy(Object object) {
        if (!skipSpring) {
            try {
                object = SpringProxy.unproxy(object);
            }
            catch (Throwable exception) {
                skipSpring = true;
            }
        }
        return object;
    }

    public static Class<?> unproxy(Class<?> type) {
        for (Class<?> interfaceClass : type.getInterfaces()) {
            if (!JAVASSIST_PROXY.equals(interfaceClass.getName())) continue;
            return type.getSuperclass();
        }
        return type;
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Method getMethod(Class<? extends Object> type, String name) {
        for (Method method : type.getMethods()) {
            if (!name.equals(method.getName())) continue;
            return method;
        }
        return null;
    }

    private static class SpringProxy {
        private SpringProxy() {
        }

        public static Object unproxy(Object object) {
            if (object != null && object instanceof Advised) {
                try {
                    object = ((Advised)object).getTargetSource().getTarget();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }
    }
}

