/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.java;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AnnotationUtils {
    private static Logger log = Logger.getLogger(AnnotationUtils.class);
    private static Map<String, List<Annotation>> annotationCache = new HashMap<String, List<Annotation>>();

    public static List<Method> getMethods(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Method> methods = new ArrayList<Method>();
        AnnotationUtils.getMethods(type, annotation, methods);
        return methods;
    }

    private static void getMethods(Class<?> type, Class<? extends Annotation> annotationType, List<Method> methods) {
        while (type != Object.class) {
            Method[] declaredMethods = type.getDeclaredMethods();
            if (declaredMethods != null) {
                for (Method method : declaredMethods) {
                    if (method.getAnnotation(annotationType) == null) continue;
                    methods.add(method);
                }
            }
            type = type.getSuperclass();
        }
    }

    public static List<Annotation> getAnnotations(Class<?> type, String property) {
        String key = type.getName() + "." + property;
        List<Annotation> annotations = annotationCache.get(key);
        if (annotations == null) {
            annotations = new ArrayList<Annotation>();
            try {
                Class<?> current = type;
                while (!Object.class.equals(current)) {
                    BeanInfo beanInfo = Introspector.getBeanInfo(current);
                    for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                        if (!property.equals(descriptor.getName())) continue;
                        Method getter = descriptor.getReadMethod();
                        if (getter == null) break;
                        annotations.addAll(Arrays.asList(getter.getAnnotations()));
                        break;
                    }
                    for (Field field : current.getFields()) {
                        if (!property.equals(field.getName())) continue;
                        annotations.addAll(Arrays.asList(field.getAnnotations()));
                        break;
                    }
                    current = current.getSuperclass();
                }
            }
            catch (Exception exception) {
                log.error((Object)("Error getting annotations from type '" + type + "' for property '" + property + "'"), (Throwable)exception);
            }
            annotationCache.put(key, annotations);
        }
        return annotations;
    }
}

