/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.io;

import com.intersult.jsf.util.io.RollingBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class StreamSplitter
implements Iterable<SplitInputStream> {
    private InputStream inputStream;
    RollingBuffer buffer;
    final byte[] delimiter;
    final byte[] end;

    public StreamSplitter(InputStream inputStream, byte[] delimiter, byte[] end) {
        this.inputStream = inputStream;
        this.delimiter = delimiter;
        this.end = end;
        this.buffer = new RollingBuffer(Math.max(delimiter.length, end.length));
    }

    int read() throws IOException {
        this.buffer.write(this.inputStream);
        if (this.buffer.equals(this.delimiter) || this.buffer.equals(this.end)) {
            return -1;
        }
        return this.buffer.read();
    }

    public void write(byte[] bytes) {
        this.buffer.write(bytes);
    }

    @Override
    public Iterator<SplitInputStream> iterator() {
        return new Iterator<SplitInputStream>(){

            @Override
            public SplitInputStream next() {
                SplitInputStream inputStream = new SplitInputStream();
                this.omitJunk();
                if (StreamSplitter.this.buffer.equals(StreamSplitter.this.end)) {
                    return null;
                }
                if (StreamSplitter.this.buffer.equals(StreamSplitter.this.delimiter)) {
                    StreamSplitter.this.buffer.skip(StreamSplitter.this.delimiter.length);
                }
                return inputStream;
            }

            @Override
            public boolean hasNext() {
                this.omitJunk();
                if (StreamSplitter.this.buffer.peek() == -1) {
                    return false;
                }
                return !StreamSplitter.this.buffer.equals(StreamSplitter.this.end);
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException();
            }

            private void omitJunk() {
                try {
                    while (StreamSplitter.this.read() != -1) {
                    }
                }
                catch (IOException exception) {
                    throw new IllegalArgumentException("Error omitting junk", exception);
                }
            }
        };
    }

    public class SplitInputStream
    extends InputStream {
        @Override
        public int read() throws IOException {
            return StreamSplitter.this.read();
        }
    }
}

