/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RollingBuffer {
    private byte[] buffer;
    private int position;
    private int length;

    public RollingBuffer(int size) {
        this.buffer = new byte[size];
    }

    public int read() {
        if (this.length > 0) {
            int result = this.buffer[this.position] & 0xFF;
            --this.length;
            this.position = (this.position + 1) % this.buffer.length;
            return result;
        }
        return -1;
    }

    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int position, int length) {
        length = Math.min(this.length, length);
        this.get(buffer, position, length);
        this.decrement(length);
        return length;
    }

    public void read(OutputStream outputStream) throws IOException {
        if (this.position + this.length > this.buffer.length) {
            outputStream.write(this.buffer, this.position, this.buffer.length - this.position);
            outputStream.write(this.buffer, 0, this.length - (this.buffer.length - this.position));
        } else {
            outputStream.write(this.buffer, this.position, this.length);
        }
        this.clear();
    }

    public byte peek() {
        if (this.length > 0) {
            return this.buffer[this.position];
        }
        return -1;
    }

    public int peek(byte[] buffer) {
        return this.peek(buffer, 0, buffer.length);
    }

    public int peek(byte[] buffer, int position, int length) {
        length = Math.min(this.length, length);
        this.get(buffer, position, length);
        return length;
    }

    private void get(byte[] buffer, int position, int length) {
        if (this.position + length > this.buffer.length) {
            int firstLength = this.buffer.length - this.position;
            System.arraycopy(this.buffer, this.position, buffer, position, firstLength);
            System.arraycopy(this.buffer, 0, buffer, position + firstLength, length - firstLength);
        } else {
            System.arraycopy(this.buffer, this.position, buffer, position, length);
        }
    }

    public void skip() {
        if (this.length > 0) {
            --this.length;
            this.position = (this.position + 1) % this.buffer.length;
        }
    }

    public void skip(int length) {
        length = Math.min(this.length, length);
        this.length -= length;
        this.position = (this.position + length) % this.buffer.length;
    }

    public boolean equals(byte[] buffer) {
        return this.equals(buffer, 0, buffer.length);
    }

    public boolean equals(byte[] buffer, int position, int length) {
        if (this.position + length > this.buffer.length) {
            int firstLength = this.buffer.length - this.position;
            if (!RollingBuffer.compare(this.buffer, this.position, buffer, position, firstLength)) {
                return false;
            }
            return RollingBuffer.compare(this.buffer, 0, buffer, position + firstLength, length - firstLength);
        }
        return RollingBuffer.compare(this.buffer, this.position, buffer, position, length);
    }

    private static boolean compare(byte[] left, int leftPosition, byte[] right, int rightPosition, int length) {
        for (int i = 0; i < length; ++i) {
            if (left[leftPosition++] == right[rightPosition++]) continue;
            return false;
        }
        return true;
    }

    public void write(int data) {
        this.checkCapacity(1);
        this.buffer[(this.position + this.length) % this.buffer.length] = (byte)data;
        ++this.length;
    }

    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int position, int length) {
        this.checkCapacity(length);
        if (this.position + length > this.buffer.length) {
            int firstLength = this.buffer.length - this.position;
            System.arraycopy(buffer, position, this.buffer, this.position, firstLength);
            System.arraycopy(buffer, position + firstLength, this.buffer, 0, length - firstLength);
        } else {
            System.arraycopy(buffer, position, this.buffer, this.position, length);
        }
        this.increment(length);
    }

    public int write(InputStream inputStream) throws IOException {
        int size;
        if (this.position + this.length < this.buffer.length) {
            int size2;
            size = inputStream.read(this.buffer, this.position + this.length, this.buffer.length - (this.position + this.length));
            if (this.position > 0 && size == this.buffer.length - (this.position + this.length) && (size2 = inputStream.read(this.buffer, 0, this.position)) > 0) {
                size += size2;
            }
        } else {
            size = inputStream.read(this.buffer, (this.position + this.length) % this.buffer.length, this.buffer.length - this.length);
        }
        if (size == -1) {
            return -1;
        }
        this.length += size;
        return size;
    }

    public void checkCapacity(int length) {
        int capacity = this.buffer.length - this.length;
        if (length > capacity) {
            throw new IndexOutOfBoundsException("Write length " + length + " exceeds free capacity " + capacity);
        }
    }

    public void increment(int length) {
        this.length += length;
    }

    public void decrement(int length) {
        this.length -= length;
        this.position = (this.position + length) % this.buffer.length;
    }

    public int length() {
        return this.buffer.length;
    }

    public int available() {
        return this.length;
    }

    public void clear() {
        this.position = (this.position + this.length) % this.buffer.length;
        this.length = 0;
    }
}

