/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.io;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class IOUtils {
    public static final String NEWLINE = "\r\n";

    public static String readString(InputStream inputStream) throws IOException {
        return new String(IOUtils.read(inputStream));
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, outputStream);
        return outputStream.toByteArray();
    }

    public static byte[] read(InputStream inputStream, int max) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy(inputStream, outputStream, max);
        return outputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            int size;
            byte[] buffer = new byte[2048];
            while ((size = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, size);
            }
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, int max) throws IOException {
        try {
            byte[] buffer = new byte[2048];
            int total = 0;
            while (true) {
                int left;
                int size = inputStream.read(buffer, 0, buffer.length < (left = max - total) ? buffer.length : left);
                total += size;
                if (size < 0) break;
                if (max <= total) {
                    break;
                }
                outputStream.write(buffer, 0, size);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static void write(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static void writeLine(OutputStream outputStream, String string) throws IOException {
        outputStream.write((string + NEWLINE).getBytes());
    }

    public static void writeLine(OutputStream outputStream) throws IOException {
        outputStream.write(NEWLINE.getBytes());
    }

    public static String readLine(InputStream inputStream) throws IOException {
        int c = inputStream.read();
        if (c == -1) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        do {
            if (c == 13) {
                inputStream.read();
                break;
            }
            if (c == 10) continue;
            buffer.append((char)c);
        } while ((c = inputStream.read()) != -1);
        return buffer.toString();
    }

    public static void dispose(InputStream inputStream) throws IOException {
        int size;
        byte[] buffer = new byte[2048];
        while ((size = inputStream.read(buffer)) >= 0) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        FileInputStream inputStream = new FileInputStream(source);
        FileChannel sourceChannel = inputStream.getChannel();
        FileOutputStream outputStream = new FileOutputStream(target);
        FileChannel targetChannel = outputStream.getChannel();
        try {
            sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        }
        finally {
            if (sourceChannel != null) {
                sourceChannel.close();
            }
            if (targetChannel != null) {
                targetChannel.close();
            }
            inputStream.close();
            outputStream.close();
            target.setLastModified(source.lastModified());
        }
    }

    public static String relative(File base, File file) throws IOException {
        String basePath = base.getCanonicalPath();
        String filePath = file.getCanonicalPath();
        if (!filePath.startsWith(basePath)) {
            throw new IllegalAccessError("File path '" + filePath + "' does not start with base path '" + basePath + "'");
        }
        int index = basePath.length();
        if (filePath.charAt(index) == File.separatorChar) {
            ++index;
        }
        String relative = filePath.substring(index);
        return relative;
    }
}

