/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.io;

import com.intersult.jsf.multipart.LinkedCaseInsensitiveHashMap;
import com.intersult.jsf.util.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class HttpUtils {
    public static Pattern HEADER_SPLIT = Pattern.compile("\\s+");
    public static Pattern PROTOCOL_SPLIT = Pattern.compile("/");
    public static final String HTTP_PROTOCOL = "HTTP";
    public static final String HTTP_VERSION = "1.1";
    public static final String HTTP11 = "HTTP/1.1";
    public static final String VERB_CONNECT = "CONNECT";
    public static final String VERB_GET = "GET";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public static void proxyConnect(Socket outgoing, String host, int port) throws IOException {
        String line;
        OutputStream outputStream = outgoing.getOutputStream();
        String target = host + ":" + port;
        IOUtils.write(outputStream, "CONNECT " + target + " " + HTTP_PROTOCOL + "/" + HTTP_VERSION + "\r\n");
        IOUtils.write(outputStream, "HOST " + target + "\r\n");
        IOUtils.write(outputStream, "\r\n");
        outputStream.flush();
        while ((line = IOUtils.readLine(outgoing.getInputStream())) != null && !"".equals(line)) {
            System.out.println(line);
        }
    }

    public static LinkedCaseInsensitiveHashMap<String> readHeaders(InputStream inputStream) throws IOException {
        String line;
        LinkedCaseInsensitiveHashMap<String> inputPropertyMap = new LinkedCaseInsensitiveHashMap<String>();
        while ((line = IOUtils.readLine(inputStream)) != null && !"".equals(line)) {
            int index = line.indexOf(58);
            String name = index < 0 ? line : line.substring(0, index);
            String value = index < 0 ? null : line.substring(index + 1).trim();
            inputPropertyMap.put(name, value);
        }
        return inputPropertyMap;
    }

    public static void writeHeaders(OutputStream outputStream, Map<String, String> headerMap) throws IOException {
        for (Map.Entry<String, String> property : headerMap.entrySet()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(property.getKey());
            if (property.getValue() != null) {
                buffer.append(": ");
                buffer.append(property.getValue());
            }
            buffer.append("\r\n");
            IOUtils.write(outputStream, buffer.toString());
        }
        IOUtils.write(outputStream, "\r\n");
    }

    static {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

