/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.io;

import java.nio.charset.Charset;

public class Base64Codec {
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final int CHUNK_SIZE = 76;
    private static final byte[] CHUNK_SEPARATOR = new byte[]{13, 10};
    private static final byte PAD = 61;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final byte[] STANDARD_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int MASK_6BITS = 63;
    private static final int MASK_8BITS = 255;
    private final int lineLength;
    private final byte[] lineSeparator;
    private final int decodeSize;
    private final int encodeSize;
    private byte[] buffer;
    private int pos;
    private int readPos;
    private int currentLinePos;
    private int modulus;
    private boolean eof;
    private int x;
    private boolean pad;

    private Base64Codec(int lineLength, byte[] lineSeparator, boolean pad) {
        this.pad = pad;
        if (lineSeparator == null) {
            lineLength = 0;
            lineSeparator = CHUNK_SEPARATOR;
        }
        this.lineLength = lineLength > 0 ? lineLength / 4 * 4 : 0;
        this.lineSeparator = lineSeparator;
        this.encodeSize = lineLength > 0 ? 4 + lineSeparator.length : 4;
        this.decodeSize = this.encodeSize - 1;
    }

    private int avail() {
        return this.buffer != null ? this.pos - this.readPos : 0;
    }

    private void resizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[8192];
            this.pos = 0;
            this.readPos = 0;
        } else {
            byte[] b = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, b, 0, this.buffer.length);
            this.buffer = b;
        }
    }

    private int readResults(byte[] bytes) {
        if (this.buffer != null) {
            int len = Math.min(this.avail(), bytes.length);
            if (this.buffer != bytes) {
                System.arraycopy(this.buffer, this.readPos, bytes, 0, len);
                this.readPos += len;
                if (this.readPos >= this.pos) {
                    this.buffer = null;
                }
            } else {
                this.buffer = null;
            }
            return len;
        }
        return this.eof ? -1 : 0;
    }

    private void setInitialBuffer(byte[] out, int outPos, int outAvail) {
        if (out != null && out.length == outAvail) {
            this.buffer = out;
            this.pos = outPos;
            this.readPos = outPos;
        }
    }

    private void encode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
            if (this.buffer == null || this.buffer.length - this.pos < this.encodeSize) {
                this.resizeBuffer();
            }
            switch (this.modulus) {
                case 1: {
                    this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 2 & 0x3F];
                    this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x << 4 & 0x3F];
                    if (!this.pad) break;
                    this.buffer[this.pos++] = 61;
                    this.buffer[this.pos++] = 61;
                    break;
                }
                case 2: {
                    this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 10 & 0x3F];
                    this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 4 & 0x3F];
                    this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x << 2 & 0x3F];
                    if (!this.pad) break;
                    this.buffer[this.pos++] = 61;
                }
            }
            if (this.lineLength > 0 && this.pos > 0) {
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
            }
        } else {
            for (int i = 0; i < inAvail; ++i) {
                int b;
                if (this.buffer == null || this.buffer.length - this.pos < this.encodeSize) {
                    this.resizeBuffer();
                }
                ++this.modulus;
                this.modulus %= 3;
                if ((b = in[inPos++]) < 0) {
                    b += 256;
                }
                this.x = (this.x << 8) + b;
                if (0 != this.modulus) continue;
                this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 18 & 0x3F];
                this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 12 & 0x3F];
                this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x >> 6 & 0x3F];
                this.buffer[this.pos++] = STANDARD_ENCODE_TABLE[this.x & 0x3F];
                this.currentLinePos += 4;
                if (this.lineLength <= 0 || this.lineLength > this.currentLinePos) continue;
                System.arraycopy(this.lineSeparator, 0, this.buffer, this.pos, this.lineSeparator.length);
                this.pos += this.lineSeparator.length;
                this.currentLinePos = 0;
            }
        }
    }

    private void decode(byte[] in, int inPos, int inAvail) {
        if (this.eof) {
            return;
        }
        if (inAvail < 0) {
            this.eof = true;
        }
        for (int i = 0; i < inAvail; ++i) {
            byte b;
            if (this.buffer == null || this.buffer.length - this.pos < this.decodeSize) {
                this.resizeBuffer();
            }
            if ((b = in[inPos++]) == 61) {
                this.eof = true;
                break;
            }
            byte result = DECODE_TABLE[b];
            if (result < 0) continue;
            ++this.modulus;
            this.modulus %= 4;
            this.x = (this.x << 6) + result;
            if (this.modulus != 0) continue;
            this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
            this.buffer[this.pos++] = (byte)(this.x >> 8 & 0xFF);
            this.buffer[this.pos++] = (byte)(this.x & 0xFF);
        }
        if (this.eof && this.modulus != 0) {
            this.x <<= 6;
            switch (this.modulus) {
                case 2: {
                    this.x <<= 6;
                    this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    break;
                }
                case 3: {
                    this.buffer[this.pos++] = (byte)(this.x >> 16 & 0xFF);
                    this.buffer[this.pos++] = (byte)(this.x >> 8 & 0xFF);
                }
            }
        }
    }

    private static byte[] getBytesUtf8(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(UTF_8);
    }

    private byte[] decode(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int len = bytes.length * 3 / 4;
        byte[] buf = new byte[len];
        this.setInitialBuffer(buf, 0, buf.length);
        this.decode(bytes, 0, bytes.length);
        this.decode(bytes, 0, -1);
        byte[] result = new byte[this.pos];
        this.readResults(result);
        return result;
    }

    public static String encode(byte[] bytes) {
        return Base64Codec.encode(bytes, false, true);
    }

    public static String encode(byte[] bytes, boolean chunked, boolean pad) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        Base64Codec base64 = new Base64Codec(chunked ? 76 : 0, CHUNK_SEPARATOR, pad);
        return Base64Codec.newStringUtf8(base64.encodeBytes(bytes));
    }

    public static byte[] decode(String base64String) {
        return new Base64Codec(76, CHUNK_SEPARATOR, true).decode(Base64Codec.getBytesUtf8(base64String));
    }

    private static String newStringUtf8(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, UTF_8);
    }

    private byte[] encodeBytes(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        int len = Base64Codec.getEncodeLength(bytes, this.lineLength, this.lineSeparator);
        byte[] buf = new byte[len];
        this.setInitialBuffer(buf, 0, buf.length);
        this.encode(bytes, 0, bytes.length);
        this.encode(bytes, 0, -1);
        if (this.buffer != buf) {
            this.readResults(buf);
        }
        return buf;
    }

    private static int getEncodeLength(byte[] bytes, int chunkSize, byte[] chunkSeparator) {
        chunkSize = chunkSize / 4 * 4;
        int len = bytes.length * 4 / 3;
        int mod = len % 4;
        if (mod != 0) {
            len += 4 - mod;
        }
        if (chunkSize > 0) {
            boolean lenChunksPerfectly = len % chunkSize == 0;
            len += len / chunkSize * chunkSeparator.length;
            if (!lenChunksPerfectly) {
                len += chunkSeparator.length;
            }
        }
        return len;
    }
}

