/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class SetList<E>
implements List<E> {
    private Set<E> set;
    private Map<Integer, E> map;

    public SetList(Set<E> set) {
        this.set = set;
        this.index();
    }

    private void index() {
        this.map = new HashMap<Integer, E>();
        int index = 0;
        for (E object : this.set) {
            this.map.put(index++, object);
        }
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean result = this.set.add(e);
        if (result) {
            this.map.put(this.map.size(), e);
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean object = this.set.remove(o);
        this.index();
        return object;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E object : c) {
            if (!this.add(object)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.set.retainAll(c);
        if (changed) {
            this.index();
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.set.removeAll(c);
        if (changed) {
            this.index();
        }
        return changed;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.map.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.set.equals(o);
    }

    @Override
    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.addAll(c);
    }

    @Override
    public E get(int index) {
        return this.map.get(index);
    }

    @Override
    public E set(int index, E element) {
        E object = this.map.get(index);
        this.set.remove(object);
        this.set.add(object);
        this.index();
        return object;
    }

    @Override
    public void add(int index, E element) {
        this.set.add(element);
    }

    @Override
    public E remove(int index) {
        E object = this.map.get(index);
        this.set.remove(object);
        this.index();
        return object;
    }

    @Override
    public int indexOf(Object o) {
        int hash = this.hash(o);
        for (Map.Entry<Integer, E> entry : this.map.entrySet()) {
            E element = entry.getValue();
            if (hash != this.hash(element) || element != o && (element == null || !element.equals(o))) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        int hash = this.hash(o);
        for (Map.Entry<Integer, E> entry : this.map.entrySet()) {
            E element = entry.getValue();
            if (hash != this.hash(element) || element != o && (element == null || !element.equals(o))) continue;
            index = entry.getKey();
        }
        return index;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new SetListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new SetListIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return null;
    }

    private int hash(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public class SetListIterator
    implements ListIterator<E> {
        private int index;

        public SetListIterator() {
            this(-1);
        }

        public SetListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < SetList.this.size();
        }

        @Override
        public E next() {
            return SetList.this.get(++this.index);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return SetList.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index + 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            SetList.this.remove(this.index);
        }

        @Override
        public void set(E e) {
            SetList.this.set(this.index, e);
        }

        @Override
        public void add(E e) {
            SetList.this.add(this.index, e);
        }
    }
}

