/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util.collection;

import java.util.Iterator;

public class JoinIterator<T>
implements Iterator<T> {
    private Iterable<T>[] iterables;
    private Iterator<T>[] iterators;
    private int index;

    public JoinIterator(Iterable<T> ... iterables) {
        this.iterables = iterables;
        this.iterators = new Iterator[iterables.length];
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.iterators.length) {
            if (this.getIterator(this.index).hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public T next() {
        return this.getIterator(this.index).next();
    }

    @Override
    public void remove() {
        this.getIterator(this.index).remove();
    }

    public Iterator<T> getIterator(int index) {
        Iterator<T> iterator = this.iterators[index];
        if (iterator == null) {
            this.iterators[index] = iterator = this.iterables[index].iterator();
        }
        return iterator;
    }
}

