/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.Jsf;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

@ManagedBean
@ViewScoped
public class Update
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SortedSet<String> events = new TreeSet<String>();
    private Set<String> headerResources = new HashSet<String>();

    public static Update instance() {
        return Jsf.getBean(Update.class);
    }

    public void event(String event, Object ... arguments) {
        this.events.add(event);
    }

    public synchronized void processEvents() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context.getPartialViewContext().isPartialRequest()) {
            this.processRenderMap(context);
            this.processWildcardRenderMap(context);
        }
        this.events.clear();
    }

    public void processRenderMap(FacesContext context) {
        Map<String, Set<String>> renderMap = Jsf.getRenderMap(context);
        for (String event : this.events) {
            Set<String> set = renderMap.get(event);
            if (set == null) continue;
            for (String clientId : set) {
                Jsf.renderClientId(clientId);
            }
        }
    }

    public void processWildcardRenderMap(FacesContext context) {
        SortedMap<String, Set<String>> renderMap = Jsf.getWildcardRenderMap(context);
        for (Map.Entry renderEntry : renderMap.entrySet()) {
            if (this.events.subSet((String)renderEntry.getKey(), (String)renderEntry.getKey() + '\uffff').isEmpty()) continue;
            for (String clientId : (Set)renderEntry.getValue()) {
                Jsf.renderClientId(clientId);
            }
        }
    }

    public synchronized List<UIComponent> processResources() {
        ArrayList<UIComponent> added = new ArrayList<UIComponent>();
        FacesContext context = FacesContext.getCurrentInstance();
        List resources = context.getViewRoot().getComponentResources(context, "head");
        for (UIComponent resource : resources) {
            String resourceId = Jsf.getResourceId(resource);
            if (this.headerResources.contains(resourceId)) continue;
            this.headerResources.add(resourceId);
            added.add(resource);
        }
        return added;
    }
}

