/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class LoginFilter
implements Filter {
    public static final String METHOD = "BASIC";
    private String[] credentials;

    public void init(FilterConfig filterConfig) throws ServletException {
        String credentials = filterConfig.getInitParameter("credentials");
        if (credentials != null) {
            this.credentials = credentials.split(",");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.auth(httpRequest, httpResponse)) {
            chain.doFilter(request, response);
        }
    }

    private boolean auth(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String authorization = httpRequest.getHeader("authorization");
        if (authorization != null && !"".equals(authorization) && authorization.length() > METHOD.length()) {
            BASE64Decoder decoder = new BASE64Decoder();
            String credentials = new String(decoder.decodeBuffer(authorization.substring(METHOD.length() + 1)));
            for (String serverCredentials : this.credentials) {
                if (!serverCredentials.equals(credentials)) continue;
                return true;
            }
        }
        httpResponse.addHeader("WWW-Authenticate", "Basic realm=\"Login\"");
        httpResponse.setStatus(401);
        return false;
    }

    public void destroy() {
    }
}

