/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.util.SelectItemComparator;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.validation.constraints.NotNull;

@ManagedBean
@SessionScoped
public class Locales
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Pattern LOCALE_SLIT_PATTERN = Pattern.compile("_");
    private List<SelectItem> currencySelectItems;
    private List<SelectItem> countrySelectItems;
    private List<SelectItem> languageSelectItems;
    private List<SelectItem> localeSelectItems;
    private List<SelectItem> supportedLocaleSelectItems;
    private Locale locale;

    public static Locales instance() {
        return Jsf.getBean(Locales.class);
    }

    public List<SelectItem> getCurrencySelectItems() {
        if (this.currencySelectItems == null) {
            this.currencySelectItems = new ArrayList<SelectItem>();
            Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (String country : Locale.getISOCountries()) {
                Locale locale = new Locale("", country);
                Currency currency = Currency.getInstance(locale);
                if (currency == null) continue;
                String currencyCode = currency.getCurrencyCode();
                String symbol = currency.getSymbol(Locale.US);
                this.currencySelectItems.add(new SelectItem((Object)symbol, currencyCode));
            }
            Collections.sort(this.currencySelectItems, new SelectItemComparator(Collator.getInstance(userLocale)));
        }
        return this.currencySelectItems;
    }

    public List<SelectItem> getCountrySelectItems() {
        if (this.countrySelectItems == null) {
            this.countrySelectItems = new ArrayList<SelectItem>();
            Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (String country : Locale.getISOCountries()) {
                Locale locale = new Locale("", country);
                this.countrySelectItems.add(new SelectItem((Object)country, locale.getDisplayCountry(userLocale)));
            }
            Collections.sort(this.countrySelectItems, new SelectItemComparator(Collator.getInstance(userLocale)));
        }
        return this.countrySelectItems;
    }

    public List<SelectItem> getLanguageSelectItems() {
        if (this.languageSelectItems == null) {
            this.languageSelectItems = new ArrayList<SelectItem>();
            Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (String language : Locale.getISOLanguages()) {
                Locale locale = new Locale(language);
                this.languageSelectItems.add(new SelectItem((Object)language, locale.getDisplayLanguage(userLocale)));
            }
            Collections.sort(this.languageSelectItems, new SelectItemComparator(Collator.getInstance(userLocale)));
        }
        return this.languageSelectItems;
    }

    public List<SelectItem> getLocaleSelectItems() {
        if (this.localeSelectItems == null) {
            this.localeSelectItems = new ArrayList<SelectItem>();
            Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            for (Locale locale : Locale.getAvailableLocales()) {
                String label = this.getLocaleLabel(userLocale, locale);
                this.localeSelectItems.add(new SelectItem((Object)locale, label));
            }
            Collections.sort(this.localeSelectItems, new SelectItemComparator(Collator.getInstance(userLocale)));
        }
        return this.localeSelectItems;
    }

    public static String getDisplayCountry(String country) {
        return Locales.getDisplayCountry(new Locale("", country));
    }

    public static String getDisplayCountry(Locale locale) {
        Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        return locale.getDisplayCountry(userLocale);
    }

    public static String getDisplayLanguage(String language) {
        return Locales.getDisplayLanguage(new Locale(language));
    }

    public static String getDisplayLanguage(Locale locale) {
        Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
        return locale.getDisplayLanguage(userLocale);
    }

    public List<SelectItem> getSupportedLocaleSelectItems() {
        if (this.supportedLocaleSelectItems == null) {
            this.supportedLocaleSelectItems = new ArrayList<SelectItem>();
            Iterator iterator = FacesContext.getCurrentInstance().getApplication().getSupportedLocales();
            Locale userLocale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                String label = this.getLocaleLabel(userLocale, locale);
                this.supportedLocaleSelectItems.add(new SelectItem((Object)locale, label));
            }
        }
        return this.supportedLocaleSelectItems;
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(String localeString) {
        String[] strings = LOCALE_SLIT_PATTERN.split(localeString);
        Locale locale = strings.length == 1 ? new Locale(strings[0]) : (strings.length == 2 ? new Locale(strings[0], strings[1]) : (strings.length == 3 ? new Locale(strings[0], strings[1], strings[2]) : Locale.getDefault()));
        this.setLocale(locale);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.currencySelectItems = null;
        this.countrySelectItems = null;
        this.languageSelectItems = null;
        this.localeSelectItems = null;
    }

    public String getLocaleLabel(Locale userLocale, Locale locale) {
        String label = locale.getDisplayLanguage(userLocale);
        if (!"".equals(locale.getCountry())) {
            label = label + " (" + locale.getDisplayCountry(userLocale) + ")";
        }
        if (!Locale.ENGLISH.equals(userLocale)) {
            label = label + " - " + locale.getDisplayLanguage(Locale.ENGLISH);
            if (!"".equals(locale.getCountry())) {
                label = label + " (" + locale.getDisplayCountry(Locale.ENGLISH) + ")";
            }
        }
        return label;
    }
}

