/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.debug.DebugUtils;
import com.intersult.jsf.el.Interpolator;
import com.intersult.jsf.messages.Resource;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import org.apache.log4j.Logger;

@ManagedBean
@SessionScoped
public class Debug
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(Debug.class);

    public String handleCommand(String command, String[] params) {
        try {
            if ("help".equals(command)) {
                return Resource.getString("debug.help");
            }
            if ("mem".equals(command)) {
                Runtime runtime = Runtime.getRuntime();
                return Resource.getFormat("debug.command.mem", runtime.freeMemory(), runtime.totalMemory(), runtime.maxMemory());
            }
            if ("get".equals(command)) {
                if (params.length != 1) {
                    return Resource.getString("debug.get.params.error");
                }
                return String.valueOf(Interpolator.get(params[0], Object.class));
            }
            if ("set".equals(command)) {
                if (params.length != 2) {
                    return Resource.getString("debug.set.params.error");
                }
                Interpolator.set(params[0], String.class, params[1]);
                return Resource.getString("debug.success");
            }
            if ("sizeof".equals(command)) {
                if (params.length != 1) {
                    return Resource.getString("debug.sizeof.params.error");
                }
                Object object = Interpolator.get(params[0], Object.class);
                int size = 0;
                if (object != null) {
                    if (!(object instanceof Serializable)) {
                        return Resource.getFormat("debug.sizeof.serializable.error", object.getClass().getName());
                    }
                    size = DebugUtils.sizeof((Serializable)object);
                }
                return Resource.getFormat("debug.sizeof.result", size);
            }
            if ("list".equals(command)) {
                if (params.length != 1) {
                    return Resource.getString("debug.list.params.error");
                }
                Object object = Interpolator.get(params[0], Object.class);
                StringWriter writer = new StringWriter();
                PrintWriter print = new PrintWriter(writer);
                if (object instanceof Map) {
                    for (Object key : ((Map)object).keySet()) {
                        print.println(key);
                    }
                } else if (object instanceof Iterable) {
                    for (Object element : (Iterable)object) {
                        print.println(element);
                    }
                } else if (object instanceof ResourceBundle) {
                    Enumeration<String> enumeration = ((ResourceBundle)object).getKeys();
                    while (enumeration.hasMoreElements()) {
                        print.println(enumeration.nextElement());
                    }
                } else {
                    BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
                    for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                        print.println(propertyDescriptor.getName());
                    }
                    for (FeatureDescriptor featureDescriptor : beanInfo.getMethodDescriptors()) {
                        String name = featureDescriptor.getName();
                        if (Object.class.equals(((MethodDescriptor)featureDescriptor).getMethod().getDeclaringClass()) || name.startsWith("get") || name.startsWith("is") || name.startsWith("set")) continue;
                        print.println(name + "()");
                    }
                }
                return writer.toString();
            }
            if ("action".equals(command)) {
                if (params.length != 1) {
                    return Resource.getString("debug.action.params.error");
                }
                return String.valueOf(Interpolator.action(params[0], Object.class, new Object[0]));
            }
            return Resource.getFormat("debug.command.unknown", command);
        }
        catch (Exception exception) {
            StringWriter writer = new StringWriter();
            exception.printStackTrace(new PrintWriter(writer));
            return writer.toString();
        }
    }

    public void exception() throws Exception {
        throw new Exception("Debug Exception");
    }

    public void trace(String text) {
        log.trace((Object)text);
    }

    public void info(String text) {
        log.info((Object)text);
    }

    public void debug(String text) {
        log.debug((Object)text);
    }

    public void warn(String text) {
        log.warn((Object)text);
    }

    public void error(String text) {
        log.error((Object)text);
    }

    public void fatal(String text) {
        log.fatal((Object)text);
    }
}

