/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.view.ExtVisitCallback;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;

public class CollectionCallback
extends ExtVisitCallback {
    private Collection<String> ids;
    private Set<String> collectedIds = new LinkedHashSet<String>();

    public CollectionCallback(Collection<String> ids) {
        this.ids = ids;
        this.addPrefixes(ids);
    }

    public VisitResult visit(VisitContext visitContext, UIComponent target) {
        UIComponent parent = target.getParent();
        if (parent == null) {
            return VisitResult.ACCEPT;
        }
        FacesContext context = visitContext.getFacesContext();
        String clientId = target.getClientId(context);
        if (this.ids.contains(clientId)) {
            this.collectedIds.add(clientId);
        } else {
            String parentId = parent.getClientId(context);
            if (this.collectedIds.contains(parentId)) {
                this.collectedIds.add(clientId);
            } else if (!this.testClientId(context, parent)) {
                return VisitResult.REJECT;
            }
        }
        return VisitResult.ACCEPT;
    }

    public Set<String> getCollectedIds() {
        return this.collectedIds;
    }
}

