/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.util.io.HttpUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.log4j.Logger;

public class CacheFilter
implements Filter {
    static final Logger log = Logger.getLogger(CacheFilter.class);
    public static final String HTTP_EXPIRES_DURATION = "http.expires.duration";
    public static final String HTTP_EXPIRES_HEADER = "Expires";
    private int expiresDuration;
    private Set<String> localhost;

    public int getExpiresDuration() {
        return this.expiresDuration;
    }

    public Set<String> getLocalhost() {
        if (this.localhost == null) {
            this.localhost = new HashSet<String>();
            try {
                for (InetAddress address : InetAddress.getAllByName("localhost")) {
                    this.localhost.add(address.getHostAddress());
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error retrieving localhost addresses", exception);
            }
        }
        return this.localhost;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            this.expiresDuration = Integer.parseInt(filterConfig.getInitParameter(HTTP_EXPIRES_DURATION));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error parsing CacheFilter init param 'http.expires.duration'", exception);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.getLocalhost().contains(((HttpServletRequest)request).getRemoteAddr())) {
            response = new CacheHttpResponse((HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public class CacheHttpResponse
    extends HttpServletResponseWrapper {
        public CacheHttpResponse(HttpServletResponse response) {
            super(response);
        }

        public void setHeader(String name, String value) {
            if (CacheFilter.HTTP_EXPIRES_HEADER.equalsIgnoreCase(name)) {
                try {
                    Date origExpires = null;
                    if (value != null && !"".equals(value)) {
                        try {
                            origExpires = HttpUtils.DATE_FORMAT.parse(value);
                        }
                        catch (Exception exception) {
                            log.error((Object)("Error parsing Expires header '" + value + "'"));
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(14, CacheFilter.this.getExpiresDuration());
                    Date newExpires = calendar.getTime();
                    if (origExpires == null || newExpires.before(origExpires)) {
                        value = HttpUtils.DATE_FORMAT.format(newExpires);
                    }
                }
                catch (Exception exception) {
                    log.error((Object)("Error setting Expires header '" + value + "'"), (Throwable)exception);
                }
            }
            super.setHeader(name, value);
        }
    }
}

