/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.util;

import com.intersult.jsf.api.ExtBehavior;
import com.sun.faces.renderkit.Attribute;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.component.behavior.ClientBehaviorHint;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;

public class Behaviors {
    public static final String DEFAULT_DELIMITER = " ";
    public static final String DEFAULT_FINALIZER = ";";
    public static final String PARAM_BEHAVIOR_EVENT = "javax.faces.behavior.event";
    public static final String PARAM_PARTIAL_RENDER = "javax.faces.partial.render";
    public static final String PARAM_PARTIAL_EXECUTE = "javax.faces.partial.execute";
    public static final String PARAM_PARTIAL_EVENT = "javax.faces.partial.event";

    public static String getValueWithBehaviors(UIComponent component, Attribute attribute) {
        StringBuilder buffer = new StringBuilder();
        Object value = Behaviors.getValue(component, attribute);
        if (value != null) {
            buffer.append(value);
        }
        boolean submitting = false;
        if (component instanceof ClientBehaviorHolder) {
            String[] events = attribute.getEvents();
            ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)component;
            if (events != null && behaviorHolder.getEventNames().contains(events[0])) {
                FacesContext context = FacesContext.getCurrentInstance();
                ClientBehaviorContext behaviorContext = ClientBehaviorContext.createClientBehaviorContext((FacesContext)context, (UIComponent)component, (String)events[0], (String)component.getClientId(), (Collection)Collections.EMPTY_LIST);
                List behaviors = (List)behaviorHolder.getClientBehaviors().get(events[0]);
                if (behaviors != null) {
                    for (ClientBehavior behavior : behaviors) {
                        String script = behavior.getScript(behaviorContext);
                        if (script == null) continue;
                        String finalizer = Behaviors.getFinalizer(behaviorContext, component, attribute, behavior);
                        String delimiter = Behaviors.getDelimiter(behaviorContext, component, attribute, behavior);
                        Behaviors.ensureDelimiter(buffer, delimiter);
                        buffer.append(script);
                        Behaviors.ensureFinalizer(buffer, delimiter, finalizer);
                        if (!behavior.getHints().contains(ClientBehaviorHint.SUBMITTING)) continue;
                        submitting = true;
                    }
                }
            }
        }
        if (submitting) {
            buffer.append(" return false;");
        }
        return buffer.toString();
    }

    public static String getDelimiter(ClientBehaviorContext behaviorContext, UIComponent component, Attribute attribute, ClientBehavior behavior) {
        String delimiter = null;
        if (behavior instanceof ExtBehavior) {
            delimiter = ((ExtBehavior)behavior).getDelimiter(behaviorContext);
        }
        if (delimiter == null && component instanceof ExtBehavior) {
            delimiter = ((ExtBehavior)component).getDelimiter(behaviorContext);
        }
        if (delimiter == null) {
            delimiter = DEFAULT_DELIMITER;
        }
        return delimiter;
    }

    public static String getFinalizer(ClientBehaviorContext behaviorContext, UIComponent component, Attribute attribute, ClientBehavior behavior) {
        String finalizer = null;
        if (behavior instanceof ExtBehavior) {
            finalizer = ((ExtBehavior)behavior).getFinalizer(behaviorContext);
        }
        if (finalizer == null && component instanceof ExtBehavior) {
            finalizer = ((ExtBehavior)component).getFinalizer(behaviorContext);
        }
        if (finalizer == null) {
            finalizer = DEFAULT_FINALIZER;
        }
        return finalizer;
    }

    public static Object getValue(UIComponent component, Attribute attribute) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueExpression expression = component.getValueExpression(attribute.getName());
        Object value = expression == null ? component.getAttributes().get(attribute.getName()) : expression.getValue(context.getELContext());
        return value;
    }

    public static void ensureFinalizer(StringBuilder buffer, String delimiter, String finalizer) {
        Behaviors.removeDelimiter(buffer, delimiter);
        if (buffer.length() > 0 && !Behaviors.endsWith(buffer, finalizer)) {
            buffer.append(finalizer);
        }
    }

    public static void removeDelimiter(StringBuilder buffer, String delimiter) {
        if (delimiter == null) {
            return;
        }
        while (Behaviors.endsWith(buffer, delimiter)) {
            buffer.setLength(buffer.length() - delimiter.length());
        }
    }

    public static void ensureDelimiter(StringBuilder buffer, String delimiter) {
        if (delimiter != null && buffer.length() > 0 && !Behaviors.endsWith(buffer, delimiter)) {
            buffer.append(delimiter);
        }
    }

    public static boolean endsWith(StringBuilder buffer, String suffix) {
        if (suffix == null) {
            return false;
        }
        int delimiterLen = suffix.length();
        if (buffer.length() < delimiterLen) {
            return false;
        }
        return suffix.equals(buffer.subSequence(buffer.length() - delimiterLen, buffer.length()));
    }

    public static String guessFinalizer(UIComponent component, String name) {
        if ("style".equals(name)) {
            return DEFAULT_FINALIZER;
        }
        if (component instanceof ClientBehaviorHolder && ((ClientBehaviorHolder)component).getEventNames().contains(name)) {
            return DEFAULT_DELIMITER;
        }
        return "";
    }
}

