/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.spring;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.ViewMapListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class ViewScope
implements Scope,
Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 1L;
    public static final String DESTRUCTION_CALLBACK_LISTENERS = "javax.faces.ViewScope.destructionCallbackListeners";
    private transient Map<HttpSession, Set<ViewMapDestroyListener>> destroyListeners;

    public Map<HttpSession, Set<ViewMapDestroyListener>> getDestroyListeners() {
        if (this.destroyListeners == null) {
            this.destroyListeners = new WeakHashMap<HttpSession, Set<ViewMapDestroyListener>>();
        }
        return this.destroyListeners;
    }

    public Object get(String name, ObjectFactory<?> objectFactory) {
        if (FacesContext.getCurrentInstance().getViewRoot() != null) {
            Map viewMap = FacesContext.getCurrentInstance().getViewRoot().getViewMap();
            if (viewMap.containsKey(name)) {
                return viewMap.get(name);
            }
            Object object = objectFactory.getObject();
            viewMap.put(name, object);
            return object;
        }
        return null;
    }

    public Object remove(String name) {
        if (FacesContext.getCurrentInstance().getViewRoot() != null) {
            return FacesContext.getCurrentInstance().getViewRoot().getViewMap().remove(name);
        }
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        ViewMapDestroyListener destroyListener = new ViewMapDestroyListener(viewRoot, callback);
        viewRoot.subscribeToViewEvent(PreDestroyViewMapEvent.class, (SystemEventListener)destroyListener);
        this.addDestroyListener(destroyListener);
        Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if (!sessionMap.containsKey(DESTRUCTION_CALLBACK_LISTENERS)) {
            sessionMap.put(DESTRUCTION_CALLBACK_LISTENERS, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDestroyListener(ViewMapDestroyListener listener) {
        Set<ViewMapDestroyListener> sessionListeners;
        HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        Object object = this.getDestroyListeners();
        synchronized (object) {
            sessionListeners = this.getDestroyListeners().get(session);
            if (sessionListeners == null) {
                sessionListeners = new LinkedHashSet<ViewMapDestroyListener>();
                this.getDestroyListeners().put(session, sessionListeners);
            }
        }
        object = sessionListeners;
        synchronized (object) {
            Iterator<ViewMapDestroyListener> iterator = sessionListeners.iterator();
            while (iterator.hasNext()) {
                ViewMapDestroyListener viewMapDestroyListener = iterator.next();
                if (!viewMapDestroyListener.isDestroyed()) continue;
                iterator.remove();
            }
            sessionListeners.add(listener);
        }
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return null;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        Set<ViewMapDestroyListener> listeners;
        Map<HttpSession, Set<ViewMapDestroyListener>> map = this.getDestroyListeners();
        synchronized (map) {
            listeners = this.getDestroyListeners().remove(event.getSession());
        }
        if (listeners != null) {
            for (ViewMapDestroyListener listener : listeners) {
                listener.processEvent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDestroyListener(ViewMapDestroyListener listener) {
        HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false);
        if (session == null) {
            return;
        }
        Map<HttpSession, Set<ViewMapDestroyListener>> map = this.getDestroyListeners();
        synchronized (map) {
            if (this.getDestroyListeners().containsKey(session)) {
                this.getDestroyListeners().get(session).remove(listener);
            }
        }
    }

    public class ViewMapDestroyListener
    implements ViewMapListener {
        private Runnable callback;
        private WeakReference<UIViewRoot> weakReference;

        public ViewMapDestroyListener(UIViewRoot viewRoot, Runnable callback) {
            this.callback = callback;
            this.weakReference = new WeakReference<UIViewRoot>(viewRoot);
        }

        public boolean isDestroyed() {
            if (this.weakReference.get() == null) {
                this.processEvent();
                return true;
            }
            return false;
        }

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            this.processEvent();
            ViewScope.this.removeDestroyListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void processEvent() {
            if (this.callback != null) {
                try {
                    this.callback.run();
                }
                finally {
                    this.callback = null;
                }
            }
        }

        public boolean isListenerForSource(Object source) {
            return source == this.weakReference.get();
        }
    }
}

