/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.spring;

import com.intersult.jsf.spring.ExtSpringScope;
import com.intersult.jsf.spring.ViewScope;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.Ordered;

public class ScopeConfigurer
implements BeanFactoryPostProcessor,
Ordered {
    public static void registerResolver(DefaultListableBeanFactory factory, Class<? extends AutowireCandidateResolver> resolverType) {
        AutowireCandidateResolver resolver;
        AutowireCandidateResolver parent = factory.getAutowireCandidateResolver();
        try {
            resolver = resolverType.getDeclaredConstructor(AutowireCandidateResolver.class).newInstance(parent);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error creating resolver '" + resolverType.getName() + "'", exception);
        }
        factory.setAutowireCandidateResolver(resolver);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope("view", (Scope)BeanUtils.instantiateClass(ViewScope.class));
        beanFactory.registerScope("scope", (Scope)BeanUtils.instantiateClass(ExtSpringScope.class));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

