/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.render;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.render.DocumentResponse;
import com.intersult.jsf.render.DocumentWriter;
import com.intersult.jsf.util.servlet.DirectServletRequest;
import com.intersult.jsf.util.servlet.DirectServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;

public class Renderer {
    public static final Pattern HTML_REPLACE_PATTERN = Pattern.compile("\\r\\n?");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document renderViewXml(ServletContext servletContext, String viewId) {
        DirectServletRequest request = new DirectServletRequest(servletContext);
        request.setPathInfo(viewId);
        DocumentResponse response = new DocumentResponse(new DirectServletResponse());
        FacesContext context = null;
        try {
            FacesContextFactory factory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            context = factory.getFacesContext((Object)servletContext, (Object)request, (Object)response, lifecycle);
            DocumentWriter writer = new DocumentWriter((Writer)context.getResponseWriter(), "application/pdf");
            context.setResponseWriter((ResponseWriter)writer);
            lifecycle.attachWindow(context);
            lifecycle.execute(context);
            lifecycle.render(context);
            writer = Jsf.unwrap(context.getResponseWriter(), DocumentWriter.class);
            Document document = writer.getDocument();
            return document;
        }
        finally {
            if (context != null) {
                context.release();
            }
        }
    }

    public static String renderView(ServletContext servletContext, String viewId) throws IOException {
        DirectServletRequest servletRequest = new DirectServletRequest(servletContext);
        servletRequest.setPathInfo(viewId);
        return Renderer.renderView(servletContext, servletRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderView(ServletContext servletContext, HttpServletRequest servletRequest) throws IOException {
        DirectServletResponse servletResponse = new DirectServletResponse();
        FacesContext context = null;
        try {
            FacesContextFactory factory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            context = factory.getFacesContext((Object)servletContext, (Object)servletRequest, (Object)servletResponse, lifecycle);
            lifecycle.attachWindow(context);
            lifecycle.execute(context);
            lifecycle.render(context);
            String string = new String(servletResponse.getOutputStream().toByteArray(), servletResponse.getCharacterEncoding());
            return string;
        }
        finally {
            if (context != null) {
                context.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String renderView(FacesContext context) throws IOException {
        try {
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Lifecycle lifecycle = lifecycleFactory.getLifecycle("DEFAULT");
            lifecycle.attachWindow(context);
            lifecycle.execute(context);
            lifecycle.render(context);
            DirectServletResponse response = (DirectServletResponse)context.getExternalContext().getResponse();
            String string = new String(response.getOutputStream().toByteArray(), response.getCharacterEncoding());
            return string;
        }
        finally {
            if (context != null) {
                context.release();
            }
        }
    }

    public static String toHtml(String string) {
        if (string == null) {
            return null;
        }
        return HTML_REPLACE_PATTERN.matcher(string).replaceAll("<br>");
    }
}

