/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.render;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentWriter
extends ResponseWriter {
    private Writer writer;
    private Document document;
    private Node current;
    private String contentType;
    private String characterEncoding = "UTF-8";

    public DocumentWriter(Writer writer, String contentType) {
        this.writer = writer;
        this.contentType = contentType;
    }

    public Document getDocument() {
        if (this.document == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.document = factory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.document;
    }

    public Node getCurrent() {
        if (this.current == null) {
            this.current = this.getDocument();
        }
        return this.current;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void startDocument() throws IOException {
    }

    public void endDocument() throws IOException {
    }

    public void startElement(String name, UIComponent component) throws IOException {
        Element node = this.getDocument().createElement(name);
        if (this.getCurrent().getNodeType() != 9 || this.getCurrent().getChildNodes().getLength() > 0) {
            this.getCurrent().appendChild(node);
        }
        this.current = node;
    }

    public void endElement(String name) throws IOException {
        if (!name.equals(this.current.getNodeName())) {
            throw new IllegalArgumentException("Error calling endElement for node '" + name + "', current node is '" + this.current.getNodeName() + "'");
        }
        this.current = this.current.getParentNode();
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        Attr attribute = this.document.createAttribute(name);
        attribute.setValue(String.valueOf(value));
        this.current.getAttributes().setNamedItem(attribute);
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        String uri = FacesContext.getCurrentInstance().getExternalContext().encodeResourceURL(String.valueOf(value));
        this.writeAttribute(name, uri, property);
    }

    public void writeComment(Object comment) throws IOException {
        this.getCurrent().appendChild(this.document.createComment(String.valueOf(comment)));
    }

    public void writeText(Object text, String property) throws IOException {
        this.getCurrent().appendChild(this.document.createTextNode(String.valueOf(text)));
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.getCurrent().appendChild(this.document.createTextNode(new String(text, off, len)));
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        return new DocumentWriter(writer, this.contentType);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        String text = new String(cbuf, off, len);
        if (text.startsWith("<?")) {
            int index = text.indexOf(32);
            String target = text.substring(2, index);
            String data = text.substring(index + 1, len - 2);
            this.getCurrent().appendChild(this.getDocument().createProcessingInstruction(target, data));
        } else if (!(text.startsWith("<!") || this.getContentType().equals(text) || "~com.sun.faces.saveStateFieldMarker~".equals(text))) {
            this.getCurrent().appendChild(this.document.createTextNode(text));
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

