/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.push;

import com.intersult.jsf.push.PushContext;
import com.intersult.jsf.push.PushHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cache.UUIDBroadcasterCache;
import org.atmosphere.cpr.ApplicationConfig;
import org.atmosphere.cpr.AsyncSupportListener;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.interceptor.AtmosphereResourceLifecycleInterceptor;
import org.atmosphere.interceptor.BroadcastOnPostAtmosphereInterceptor;

public class PushResourceHandler
extends ResourceHandlerWrapper {
    public static final String LIBRARY_PARAM = "ln";
    public static final String LIBRARY_NAME = "push";
    private ResourceHandler wrapped;
    private AtmosphereAdapter atmosphereAdapter;

    public PushResourceHandler(ResourceHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public AtmosphereAdapter getAtmosphereAdapter() {
        if (this.atmosphereAdapter == null) {
            this.atmosphereAdapter = new AtmosphereAdapter();
        }
        return this.atmosphereAdapter;
    }

    public Resource createResource(String resourceName, String libraryName) {
        if (LIBRARY_NAME.equals(libraryName)) {
            return new PushResource(resourceName);
        }
        return this.wrapped.createResource(resourceName, libraryName);
    }

    public boolean libraryExists(String libraryName) {
        if (LIBRARY_NAME.equals(libraryName)) {
            return true;
        }
        return this.wrapped.libraryExists(libraryName);
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        String libraryName = (String)context.getExternalContext().getRequestParameterMap().get(LIBRARY_PARAM);
        if (LIBRARY_NAME.equals(libraryName)) {
            try {
                this.getAtmosphereAdapter().doCometSupport(context);
            }
            catch (ServletException exception) {
                throw new IOException("Error handling push request", exception);
            }
            return;
        }
        this.wrapped.handleResourceRequest(context);
    }

    public static class PushResource
    extends Resource {
        private String resourceName;

        public PushResource(String resourceName) {
            this.resourceName = resourceName;
        }

        public InputStream getInputStream() throws IOException {
            return null;
        }

        public Map<String, String> getResponseHeaders() {
            return new HashMap<String, String>();
        }

        public String getRequestPath() {
            FacesContext context = FacesContext.getCurrentInstance();
            return context.getApplication().getViewHandler().getResourceURL(context, "/faces/javax.faces.resource/" + this.resourceName + "?ln=" + PushResourceHandler.LIBRARY_NAME);
        }

        public URL getURL() {
            try {
                return new URL(this.getRequestPath());
            }
            catch (MalformedURLException exception) {
                throw new IllegalArgumentException("Error creating resourceName URL", exception);
            }
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            return true;
        }
    }

    public static class AtmosphereAdapter {
        private AtmosphereFramework framework;

        public AtmosphereFramework getFramework(FacesContext context) {
            if (this.framework == null) {
                this.framework = new AtmosphereFramework(false, false);
                this.framework.addInitParameter(ApplicationConfig.BROADCASTER_SHARABLE_THREAD_POOLS, "true");
                this.framework.asyncSupportListener((AsyncSupportListener)PushContext.instance());
                this.framework.addInitParameter(ApplicationConfig.PROPERTY_SESSION_SUPPORT, "true");
                this.framework.setBroadcasterCacheClassName(UUIDBroadcasterCache.class.getName());
                this.framework.init();
                this.framework.interceptor((AtmosphereInterceptor)new AtmosphereResourceLifecycleInterceptor());
                this.framework.interceptor((AtmosphereInterceptor)new BroadcastOnPostAtmosphereInterceptor());
                String mapping = PushContext.getBasePath(context) + "/*";
                this.framework.addAtmosphereHandler(mapping, (AtmosphereHandler)new PushHandler());
            }
            return this.framework;
        }

        public void doCometSupport(FacesContext context) throws IOException, ServletException {
            HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            AtmosphereFramework framework = this.getFramework(context);
            framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)request), AtmosphereResponse.wrap((HttpServletResponse)response));
        }
    }
}

