/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.push;

import javax.faces.context.FacesContext;
import org.atmosphere.cpr.AsyncSupportListenerAdapter;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterFactory;

public class PushContext
extends AsyncSupportListenerAdapter {
    private static PushContext instance;

    public static PushContext instance() {
        if (instance == null) {
            instance = new PushContext();
        }
        return instance;
    }

    public static String getPushUrl(FacesContext context, String channel) {
        String url = PushContext.getBasePath(context) + PushContext.normalizeChannel(channel) + "?ln=" + "push";
        return url;
    }

    public static String getBasePath(FacesContext context) {
        return context.getExternalContext().getRequestServletPath() + "/javax.faces.resource";
    }

    public static String normalizeChannel(String channel) {
        if (channel == null || "".equals(channel)) {
            return "/*";
        }
        if (!channel.startsWith("/")) {
            return "/" + channel;
        }
        return channel;
    }

    public void push(String channel) {
        this.push(channel, "{}");
    }

    public void push(String channel, Object data) {
        String id = "/javax.faces.resource" + PushContext.normalizeChannel(channel);
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory == null) {
            return;
        }
        for (Broadcaster broadcaster : factory.lookupAll()) {
            if (!this.matches(id, broadcaster.getID())) continue;
            broadcaster.broadcast(data);
        }
    }

    public int count(String channel) {
        String id = "/javax.faces.resource" + PushContext.normalizeChannel(channel);
        BroadcasterFactory factory = BroadcasterFactory.getDefault();
        if (factory == null) {
            return 0;
        }
        int count = 0;
        for (Broadcaster broadcaster : factory.lookupAll()) {
            if (!this.matches(id, broadcaster.getID())) continue;
            ++count;
        }
        return count;
    }

    public boolean matches(String id, String broadcasterId) {
        return id.equals(broadcasterId);
    }
}

