/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.navigation;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.navigation.Navigation;
import com.intersult.jsf.view.ExtViewHandler;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.ConfigurableNavigationHandlerWrapper;
import javax.faces.application.NavigationCase;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class RedirectNavigationHandler
extends ConfigurableNavigationHandlerWrapper {
    private ConfigurableNavigationHandler wrapped;

    public RedirectNavigationHandler(ConfigurableNavigationHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ConfigurableNavigationHandler getWrapped() {
        return this.wrapped;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (Jsf.isUseFlash() || Navigation.isRedirectAfterSubmit()) {
            outcome = this.handleRedirect(context, fromAction, outcome);
        }
        this.wrapped.handleNavigation(context, fromAction, outcome);
    }

    public String handleRedirect(FacesContext context, String fromAction, String outcome) {
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.isResponseCommitted() || !context.isPostback()) {
            return outcome;
        }
        boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
        if (ajaxRequest && outcome == null) {
            return null;
        }
        if (Jsf.isUseFlash()) {
            externalContext.getFlash().setKeepMessages(true);
        }
        if (outcome == null) {
            outcome = Navigation.getViewId();
        }
        String viewState = (String)externalContext.getRequestParameterMap().get("javax.faces.ViewState");
        if (outcome.contains("faces-redirect=true")) {
            viewState = null;
        } else {
            outcome = outcome + "?faces-redirect=true";
        }
        boolean sameView = this.isSameView(context, fromAction, outcome);
        if (viewState != null && externalContext.getSession(false) != null && sameView) {
            outcome = outcome + ExtViewHandler.getViewParameters(context.getViewRoot());
            if (Jsf.isUseFlash()) {
                context.getExternalContext().getFlash().put((Object)"javax.faces.ViewState", (Object)viewState);
            } else {
                outcome = outcome + "&javax.faces.ViewState=" + viewState;
            }
        }
        return outcome;
    }

    public boolean isSameView(FacesContext context, String fromAction, String outcome) {
        ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
        NavigationCase navigationCase = navigationHandler.getNavigationCase(context, fromAction, outcome);
        if (navigationCase == null) {
            return true;
        }
        String toViewId = navigationCase.getToViewId(context);
        String viewId = context.getViewRoot().getViewId();
        return viewId.equals(toViewId);
    }
}

