/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.navigation;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.view.ExtViewHandler;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;

public class Navigation {
    public static final String FACES_PREFIX = "/faces";
    public static final String FACES_REDIRECT = "faces-redirect=true";
    public static final String REDIRECT_PARAM = "javax.faces.REDIRECT";
    public static final String REDIRECT_AFTER_SUBMIT_PARAM = "javax.faces.REDIRECT_AFTER_SUBMIT";
    private static Boolean redirectAfterSubmit;
    private String path;
    private Map<String, String> params = new LinkedHashMap<String, String>();

    public Navigation(String viewId) {
        this.path = viewId;
        if (!this.path.startsWith("/faces/")) {
            this.path = FACES_PREFIX + this.path;
        }
    }

    public static boolean isRedirectAfterSubmit() {
        if (redirectAfterSubmit == null) {
            ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
            redirectAfterSubmit = "true".equals(servletContext.getInitParameter(REDIRECT_AFTER_SUBMIT_PARAM));
        }
        return redirectAfterSubmit;
    }

    public static Navigation navigate() {
        return Navigation.navigate(Navigation.getViewId());
    }

    public static Navigation navigate(String viewId) {
        return new Navigation(viewId);
    }

    public Navigation addParam(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public void redirect() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext.isResponseCommitted()) {
            return;
        }
        try {
            if (Jsf.isUseFlash()) {
                externalContext.getFlash().setKeepMessages(true);
            }
            String url = this.path;
            String viewState = (String)externalContext.getRequestParameterMap().get("javax.faces.ViewState");
            LinkedHashMap<String, List<Object>> parameters = new LinkedHashMap<String, List<Object>>();
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                parameters.put(param.getKey(), Arrays.asList(param.getValue()));
            }
            boolean addViewState = true;
            if (viewState == null || externalContext.getSession(false) == null) {
                addViewState = false;
            }
            if (context.getViewRoot() != null && !context.getViewRoot().getViewId().equals(this.path)) {
                addViewState = false;
            }
            if (addViewState) {
                Map<String, String[]> viewParameters = ExtViewHandler.getViewParameterMap();
                for (Map.Entry<String, String[]> entry : viewParameters.entrySet()) {
                    parameters.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
                }
                if (context.getRenderKit() != null && context.getRenderKit().getResponseStateManager().getState(context, this.path) != null) {
                    if (Jsf.isUseFlash()) {
                        externalContext.getFlash().put((Object)"javax.faces.ViewState", (Object)viewState);
                    } else {
                        parameters.put("javax.faces.ViewState", Arrays.asList(viewState));
                    }
                }
            }
            url = externalContext.encodeRedirectURL(url, parameters);
            if ((url = externalContext.encodeResourceURL(url)).startsWith("/") && !url.startsWith(externalContext.getRequestContextPath())) {
                url = externalContext.getRequestContextPath() + url;
            }
            externalContext.redirect(url);
        }
        catch (IOException exception) {
            throw new FacesException("Error redirecting view '" + this.path + "'", (Throwable)exception);
        }
    }

    public String toString() {
        return this.path;
    }

    public static String getViewId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        String viewId = null;
        if (viewRoot != null) {
            viewId = viewRoot.getViewId();
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.path_info");
        }
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestPathInfo();
        }
        if (viewId == null) {
            viewId = (String)requestMap.get("javax.servlet.include.servlet_path");
        }
        if (viewId == null) {
            viewId = facesContext.getExternalContext().getRequestServletPath();
        }
        if (viewId == null) {
            throw new FacesException(MessageUtils.getExceptionMessageString((String)"com.sun.faces.NULL_REQUEST_VIEW_ERROR", (Object[])new Object[0]));
        }
        return viewId;
    }

    public static String encodeURL(String url) throws UnsupportedEncodingException {
        String encoding = FacesContext.getCurrentInstance().getExternalContext().getResponseCharacterEncoding();
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return URLEncoder.encode(url, encoding);
    }

    public static String decodeURL(String url) throws UnsupportedEncodingException {
        String encoding = FacesContext.getCurrentInstance().getExternalContext().getRequestCharacterEncoding();
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return URLDecoder.decode(url, encoding);
    }

    public static String encodeViewUrl(String viewId, Map<String, List<String>> parameters) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        String url = externalContext.encodeRedirectURL(FACES_PREFIX + viewId, parameters);
        return externalContext.encodeResourceURL(url);
    }
}

