/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.multipart;

import com.intersult.jsf.multipart.HeaderValue;
import com.intersult.jsf.multipart.LinkedCaseInsensitiveHashMap;
import com.intersult.jsf.multipart.Multipart;
import com.intersult.jsf.util.io.HttpUtils;
import com.intersult.jsf.util.io.IOUtils;
import com.intersult.jsf.util.io.StreamSplitter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.mozilla.universalchardet.UniversalDetector;

public class MultipartRequest
extends HttpServletRequestWrapper {
    private static final Logger log = Logger.getLogger(MultipartRequest.class);
    public static final String MAX_DATA_ATTRIBUTE = "request.multipart.max_data";
    public static final int DEFAULT_MAX_DATA = 0x500000;
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private int max;

    public MultipartRequest(HttpServletRequest request) {
        super(request);
        this.setMax(request);
        this.processRequest(request);
    }

    public int getMax() {
        return this.max;
    }

    private void setMax(HttpServletRequest request) {
        String maxString = null;
        HttpSession session = request.getSession(false);
        if (session != null && (maxString = (String)session.getAttribute(MAX_DATA_ATTRIBUTE)) == null) {
            maxString = session.getServletContext().getInitParameter(MAX_DATA_ATTRIBUTE);
        }
        this.max = maxString == null ? 0x500000 : Integer.parseInt(maxString);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (Map.Entry<String, List<String>> parameter : this.parameters.entrySet()) {
            paramMap.put(parameter.getKey(), parameter.getValue().toArray(new String[parameter.getValue().size()]));
        }
        paramMap.putAll(super.getParameterMap());
        return paramMap;
    }

    public String getParameter(String name) {
        if (this.parameters.containsKey(name)) {
            return this.parameters.get(name).get(0);
        }
        return super.getParameter(name);
    }

    public void addParameter(String name, String value) {
        List<String> list = this.parameters.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            this.parameters.put(name, list);
        }
        list.add(value);
    }

    public Enumeration getParameterNames() {
        Vector<String> names = new Vector<String>();
        names.addAll(this.parameters.keySet());
        Enumeration enumeration = super.getParameterNames();
        while (enumeration.hasMoreElements()) {
            names.add((String)enumeration.nextElement());
        }
        return names.elements();
    }

    public String[] getParameterValues(String name) {
        String[] superValues;
        ArrayList<String> values = new ArrayList<String>();
        List<String> parameterValues = this.parameters.get(name);
        if (parameterValues != null) {
            values.addAll(parameterValues);
        }
        if ((superValues = super.getParameterValues(name)) != null) {
            values.addAll(Arrays.asList(superValues));
        }
        return values.toArray(new String[values.size()]);
    }

    private void processRequest(HttpServletRequest request) {
        try {
            InputStream inputStream;
            String charsetName = request.getCharacterEncoding();
            Charset charset = Charset.forName(charsetName == null ? "UTF-8" : charsetName);
            Multipart multipart = new Multipart(request);
            Iterator<StreamSplitter.SplitInputStream> iterator = multipart.getInputStreamIterator();
            while (iterator.hasNext() && (inputStream = (InputStream)iterator.next()) != null) {
                this.processPart(inputStream, charset);
            }
        }
        catch (Exception exception) {
            throw new FacesException("Error processing multipart request", (Throwable)exception);
        }
    }

    private void processPart(InputStream inputStream, Charset charset) throws IOException {
        LinkedCaseInsensitiveHashMap<String> headers = HttpUtils.readHeaders(inputStream);
        byte[] bytes = IOUtils.read(inputStream, this.max);
        if (bytes != null && bytes.length >= this.max) {
            throw new FacesException("Maximum upload data size of " + this.max + " exceeded");
        }
        HeaderValue contentDisposition = new HeaderValue((String)headers.get("Content-Disposition"));
        HeaderValue contentType = new HeaderValue((String)headers.get("Content-Type"));
        if ("form-data".equals(contentDisposition.getValue())) {
            String name = contentDisposition.getParameters().get("name");
            String filename = contentDisposition.getParameters().get("filename");
            if (filename == null) {
                this.addParameter(name, new String(bytes, charset));
            } else if (!"".equals(filename)) {
                try {
                    filename = new File(filename).getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.addParameter(name, filename);
                this.setAttribute(name + ":mime-type", this.getContentType(contentType, filename, bytes));
                if (bytes != null && bytes.length > 0) {
                    this.setAttribute(name + ":file", bytes);
                }
            }
        } else {
            log.warn((Object)("Unknown Content-Disposition '" + contentDisposition.getValue() + "'"));
        }
    }

    public String getContentType(HeaderValue contentType, String filename, byte[] bytes) {
        if (contentType.getValue() == null) {
            ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
            contentType.setValue(externalContext.getMimeType(filename.toLowerCase()));
        }
        if (contentType.getValue() == null || contentType.getValue().startsWith("text/")) {
            String charset = contentType.getParameters().get("charset");
            if (charset == null) {
                try {
                    charset = CharsetDetector.detectCharset(bytes);
                    if (charset != null) {
                        contentType.getParameters().put("charset", charset);
                    }
                }
                catch (Throwable exception) {
                    // empty catch block
                }
            }
            if (charset != null && contentType.getValue() == null) {
                contentType.setValue("text/plain");
            }
        }
        return contentType.toString();
    }

    private static class CharsetDetector {
        private CharsetDetector() {
        }

        public static String detectCharset(byte[] bytes) {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(bytes, 0, bytes.length);
            detector.dataEnd();
            return detector.getDetectedCharset();
        }
    }
}

