/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.multipart;

import com.intersult.jsf.multipart.HeaderValue;
import com.intersult.jsf.multipart.MultipartException;
import com.intersult.jsf.util.io.StreamSplitter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class Multipart {
    public static final String MIME_TYPE = "multipart/mixed";
    public static final String BOUNDARY_PARAM = "boundary";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    private HttpServletRequest request;
    private String inputBoundary;
    private HeaderValue contentType;
    private Iterator<StreamSplitter.SplitInputStream> inputStreamIterator;
    private Charset charset;

    public Multipart(HttpServletRequest request) {
        this.request = request;
        this.charset = Charset.forName("ISO-8859-1");
    }

    public Iterator<StreamSplitter.SplitInputStream> getInputStreamIterator() throws IOException {
        if (this.inputStreamIterator == null) {
            byte[] delimiter = ("\r\n--" + this.getInputBoundary() + "\r\n").getBytes(this.charset);
            byte[] end = ("\r\n--" + this.getInputBoundary() + "--\r\n").getBytes(this.charset);
            StreamSplitter splitter = new StreamSplitter((InputStream)this.request.getInputStream(), delimiter, end);
            splitter.write("\r\n".getBytes(this.charset));
            this.inputStreamIterator = splitter.iterator();
        }
        return this.inputStreamIterator;
    }

    public String getInputBoundary() throws IOException {
        if (this.inputBoundary == null) {
            HeaderValue contentType = this.getContentType();
            if (contentType == null) {
                throw new MultipartException("Content-Type must be multipart, but was not specified");
            }
            if (contentType.getValue() == null || !contentType.getValue().toLowerCase().startsWith("multipart")) {
                throw new MultipartException("Content-Type must be multipart, but was '" + contentType.getValue() + "'");
            }
            this.inputBoundary = contentType.getParameters().get(BOUNDARY_PARAM);
            if (this.inputBoundary == null) {
                throw new MultipartException("Content-Type multipart must specify parameter 'boundary'");
            }
        }
        return this.inputBoundary;
    }

    public HeaderValue getContentType() {
        String contentTypeValue;
        if (this.contentType == null && (contentTypeValue = this.request.getHeader(CONTENT_TYPE)) != null) {
            this.contentType = new HeaderValue(contentTypeValue);
        }
        return this.contentType;
    }
}

