/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.multipart;

import com.intersult.jsf.multipart.LinkedCaseInsensitiveHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class HeaderValue {
    public static final Pattern SPLIT_PATTERN = Pattern.compile("\\s*;\\s*");
    private String value;
    private Map<String, String> parameters = new LinkedCaseInsensitiveHashMap<String>();

    public HeaderValue() {
    }

    public HeaderValue(String header) {
        String[] strings;
        String[] stringArray = strings = header == null ? null : SPLIT_PATTERN.split(header);
        if (strings != null && strings.length > 0) {
            this.value = strings[0];
            for (int i = 1; i < strings.length; ++i) {
                int index = strings[i].indexOf(61);
                if (index < 0) {
                    this.parameters.put(strings[i], null);
                    continue;
                }
                String parameterValue = strings[i].substring(index + 1);
                if (parameterValue.length() > 1 && (parameterValue.startsWith("\"") && parameterValue.endsWith("\"") || parameterValue.startsWith("'") && parameterValue.endsWith("'"))) {
                    parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
                }
                this.parameters.put(strings[i].substring(0, index), parameterValue);
            }
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.value != null) {
            buffer.append(this.value);
        }
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            buffer.append("; ");
            buffer.append(parameter.getKey());
            if (parameter.getValue() == null) continue;
            buffer.append("=\"");
            buffer.append(parameter.getValue());
            buffer.append("\"");
        }
        return buffer.toString();
    }
}

