/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.messages;

import com.sun.faces.application.ApplicationAssociate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

public class Resource {
    public static final Pattern SEPARATOR_PATTERN = Pattern.compile(",");
    public static final String COMMA = ", ";
    public static final Pattern URL_PATTERN = Pattern.compile("(^|\\s)([a-zA-Z]*://\\S+)(\\s|$)");
    public static final Pattern WWW_PATTERN = Pattern.compile("(^|\\s)(www\\.\\S+\\.\\S+)(\\s|$)");
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("(\\r?\\n)");
    public static final Pattern EMAIL_PATTERN = Pattern.compile("(^|\\s)(\\S*@\\S+\\.\\S+)(\\s|$)");
    public static String and;
    private static String[] vars;

    public static String[] getVars() {
        if (vars == null) {
            vars = ApplicationAssociate.getCurrentInstance().getResourceBundles().keySet().toArray(new String[0]);
        }
        return vars;
    }

    public static String getAnd() {
        if (and == null) {
            and = " " + Resource.getString("and") + " ";
        }
        return and;
    }

    public static String getString(String key) {
        String value = Resource.getStringNull(key);
        return value == null ? "[" + key + "]" : value;
    }

    public static String getStringNull(String key) {
        FacesContext context = FacesContext.getCurrentInstance();
        for (String var : Resource.getVars()) {
            ResourceBundle bundle = context.getApplication().getResourceBundle(context, var);
            try {
                return bundle.getString(key);
            }
            catch (RuntimeException exception) {
            }
        }
        return null;
    }

    public static String getStringVariant(String typeName, String variant, String name) {
        String key = Resource.getKeyVariant(typeName, variant, name);
        return Resource.getString(key);
    }

    public static String getFormatVariant(String typeName, String variant, String name, Object ... arguments) {
        String key = Resource.getKeyVariant(typeName, variant, name);
        return Resource.getFormat(key, arguments);
    }

    public static String getFormat(String key, Object ... arguments) {
        return MessageFormat.format(Resource.getString(key), arguments);
    }

    private static String getKeyVariant(String typeName, String variant, String name) {
        return variant == null || "".equals(variant) ? typeName + "." + name : typeName + "." + name + "." + variant;
    }

    public static void addMessage(FacesMessage.Severity severity, String key, Object ... arguments) {
        Resource.addMessageToComponent(severity, null, key, arguments);
    }

    public static void addMessageToComponent(FacesMessage.Severity severity, String clientId, String key, Object ... arguments) {
        FacesMessage facesMessage = Resource.getMessage(severity, key, arguments);
        FacesContext.getCurrentInstance().addMessage(clientId, facesMessage);
    }

    public static FacesMessage getMessage(FacesMessage.Severity severity, String key, Object ... arguments) {
        String message = Resource.getFormat(key, arguments);
        return new FacesMessage(severity, message, null);
    }

    public static <Type extends Enum<Type>> String enumFormat(Type value, Object ... arguments) {
        return Resource.enumFormatVariant(value, null, arguments);
    }

    public static <Type extends Enum<Type>> String enumFormatVariant(Type value, String variant, Object ... arguments) {
        if (value == null) {
            return null;
        }
        return Resource.getFormatVariant(value.getDeclaringClass().getName(), variant, value.name(), new Object[0]);
    }

    public static <Type extends Enum<Type>> String enumString(Type value) {
        return Resource.enumString(value, null);
    }

    public static <Type extends Enum<Type>> String enumString(Type value, String variant) {
        if (value == null) {
            return null;
        }
        return Resource.getStringVariant(value.getDeclaringClass().getName(), variant, value.name());
    }

    public static List<Enum> enumList(String typeName) throws ClassNotFoundException {
        Class<?> type = Class.forName(typeName);
        Enum[] enumConstants = (Enum[])type.getEnumConstants();
        return Arrays.asList(enumConstants);
    }

    public static <Type extends Enum<Type>> String enumStringList(Iterable<Type> iterable) {
        return Resource.enumStringListVariant(iterable, null);
    }

    public static <Type extends Enum<Type>> String enumStringListVariant(Iterable<Type> list, String variant) {
        if (list == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<Type> iterator = list.iterator();
        while (iterator.hasNext()) {
            Enum value = (Enum)iterator.next();
            if (buffer.length() > 0) {
                buffer.append(iterator.hasNext() ? COMMA : Resource.getAnd());
            }
            buffer.append(Resource.enumString(value, variant));
        }
        return buffer.toString();
    }

    public static List<SelectItem> enumSelectItems(String typeName) throws ClassNotFoundException {
        return Resource.enumSelectItems(typeName, null);
    }

    public static List<SelectItem> enumSelectItems(String typeName, String variant) throws ClassNotFoundException {
        return Resource.enumSelectItemsTypeVariant(Class.forName(typeName), variant);
    }

    public static <Type extends Enum<Type>> List<SelectItem> enumSelectItemsType(Class<Type> type) {
        return Resource.enumSelectItemsTypeVariant(type, null);
    }

    public static <Type extends Enum<Type>> List<SelectItem> enumSelectItemsTypeVariant(Class<Type> type, String variant) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        String namesString = Resource.getStringNull(type.getName());
        if (namesString == null) {
            for (Enum value : (Enum[])type.getEnumConstants()) {
                selectItems.add(Resource.enumSelectItem(value, variant));
            }
        } else {
            String[] names;
            for (String name : names = SEPARATOR_PATTERN.split(namesString)) {
                Type value = Enum.valueOf(type, name);
                selectItems.add(Resource.enumSelectItem(value, variant));
            }
        }
        return selectItems;
    }

    public static <Type extends Enum<Type>> SelectItem enumSelectItem(Type value, String variant) {
        if (value == null) {
            return null;
        }
        String key = Resource.getKeyVariant(value.getDeclaringClass().getName(), variant, value.name());
        String label = Resource.getString(key);
        String description = Resource.getStringNull(key + ".description");
        SelectItem selectItem = new SelectItem(value, label, description);
        return selectItem;
    }

    public static String abbreviate(String text, Integer length) {
        if (text == null) {
            return null;
        }
        if (text.length() < length) {
            return text;
        }
        return text.substring(0, length - 3) + "...";
    }

    public static String replaceHtml(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("<", "&lt;");
        text = text.replace(">", "&gt;");
        text = URL_PATTERN.matcher(text).replaceAll("$1<a href=\"$2\">$2</a>$3");
        text = WWW_PATTERN.matcher(text).replaceAll("$1<a href=\"http://$2\">$2</a>$3");
        text = NEWLINE_PATTERN.matcher(text).replaceAll("<br>");
        text = EMAIL_PATTERN.matcher(text).replaceAll("$1<a href=\"mailto:$2\">$2</a>$3");
        return text;
    }
}

