/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.messages;

import com.intersult.flow.Level;
import com.intersult.flow.Message;
import com.intersult.jsf.messages.Resource;
import javax.faces.application.FacesMessage;

public class FlowMessage
extends FacesMessage {
    private static final long serialVersionUID = 1L;
    private Message message;

    public FlowMessage(Message message) {
        this.message = message;
    }

    public FacesMessage.Severity getSeverity() {
        Level level = this.message.getLevel();
        switch (level) {
            case INFO: {
                return FacesMessage.SEVERITY_INFO;
            }
            case WARN: {
                return FacesMessage.SEVERITY_WARN;
            }
            case ERROR: {
                return FacesMessage.SEVERITY_ERROR;
            }
            case FATAL: {
                return FacesMessage.SEVERITY_FATAL;
            }
        }
        throw new IllegalArgumentException("Unknown message level '" + level + "'");
    }

    public Message getMessage() {
        return this.message;
    }

    public String getSummary() {
        String summary = Resource.getFormat(this.message.getKey(), this.message.getParameters());
        if (this.message.getCount() > 1) {
            summary = summary + " (" + this.message.getCount() + ")";
        }
        return summary;
    }

    public String getDetail() {
        if (super.getDetail() == null) {
            return this.getSummary();
        }
        return super.getDetail();
    }
}

