/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.messages;

import com.intersult.flow.Flow;
import com.intersult.flow.Listener;
import com.intersult.flow.Message;
import com.intersult.jsf.Jsf;
import com.intersult.jsf.event.Event;
import com.intersult.jsf.messages.FlowMessage;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.context.FacesContext;

@ManagedBean
@ViewScoped
public class FacesMessages
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EVENTS_PROCESSED = "javax.faces.EVENTS_PROCESSED";
    public static final String GLOBAL = "javax.faces.messages";
    private Set<String> events;
    private Set<String> stored = new HashSet<String>();

    public static FacesMessages instance() {
        return Jsf.getBean(FacesMessages.class);
    }

    public Set<String> getEvents() {
        if (this.events == null) {
            this.events = new HashSet<String>();
        }
        return this.events;
    }

    public void schedule(String event) {
        this.getEvents().add(event);
    }

    public void clear() {
        this.events = null;
    }

    public void processEvents() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!context.getPartialViewContext().isPartialRequest()) {
            return;
        }
        if (!context.getAttributes().containsKey(EVENTS_PROCESSED)) {
            context.getAttributes().put(EVENTS_PROCESSED, null);
            if (!context.getMessageList(null).isEmpty()) {
                this.schedule(GLOBAL);
            }
            Iterator ids = context.getClientIdsWithMessages();
            while (ids.hasNext()) {
                String id = (String)ids.next();
                if (id == null) continue;
                this.schedule(id);
            }
            this.process();
        }
    }

    private void process() {
        Collection<String> executeIds = Jsf.getExecuteIds();
        for (String event : this.getEvents()) {
            FacesMessages.raise(executeIds, event);
        }
        this.stored.removeAll(this.getEvents());
        Iterator<String> iterator = this.stored.iterator();
        while (iterator.hasNext()) {
            String event;
            event = iterator.next();
            if (!FacesMessages.raise(executeIds, event)) continue;
            iterator.remove();
        }
        this.stored.addAll(this.getEvents());
        this.clear();
    }

    private static boolean raise(Collection<String> executeIds, String event) {
        if (executeIds.contains(event)) {
            Event.instance().raise(":" + event, new Object[0]);
            return true;
        }
        if (GLOBAL.equals(event)) {
            Event.instance().raise(event, new Object[0]);
            return true;
        }
        return false;
    }

    public static String getSeverityName(FacesMessage.Severity severity) {
        if (FacesMessage.SEVERITY_INFO == severity) {
            return "INFO";
        }
        if (FacesMessage.SEVERITY_WARN == severity) {
            return "WARN";
        }
        if (FacesMessage.SEVERITY_ERROR == severity) {
            return "ERROR";
        }
        if (FacesMessage.SEVERITY_FATAL == severity) {
            return "FATAL";
        }
        return null;
    }

    static {
        if (Jsf.isFlow()) {
            Flow.getListeners().add(new FlowListener());
        }
    }

    public static class FlowListener
    implements Listener {
        public void addMessage(Message message) {
            FacesContext.getCurrentInstance().addMessage(message.getReference(), (FacesMessage)new FlowMessage(message));
        }
    }
}

