/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.messages;

import com.intersult.jsf.extensions.ExtExceptionHandler;
import com.intersult.jsf.messages.WorkflowException;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AjaxExceptionHandler
extends ExtExceptionHandler {
    private static final String IGNORE_EXCEPTIONS_PARAM = "javax.faces.IGNORE_EXCEPTIONS";
    private static final String PASS_EXCEPTIONS_PARAM = "javax.faces.PASS_EXCEPTIONS";
    private static final Logger log = Logger.getLogger(AjaxExceptionHandler.class);
    public static final String EXCEPTION_EVENT = "java.lang.Throwable";
    private static final Set<String> ignored = new HashSet<String>();
    private static final Set<String> pass = new HashSet<String>();

    public AjaxExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
        String passExceptions;
        ServletContext servletContext = (ServletContext)FacesContext.getCurrentInstance().getExternalContext().getContext();
        String ignoreExceptions = servletContext.getInitParameter(IGNORE_EXCEPTIONS_PARAM);
        if (ignoreExceptions != null) {
            for (String ignoreException : ignoreExceptions.split(",")) {
                ignored.add(ignoreException);
            }
        }
        if ((passExceptions = servletContext.getInitParameter(PASS_EXCEPTIONS_PARAM)) != null) {
            for (String passException : passExceptions.split(",")) {
                pass.add(passException);
            }
        }
    }

    public static void ignore(String exceptionClass) {
        ignored.add(exceptionClass);
    }

    public static void pass(String exceptionClass) {
        pass.add(exceptionClass);
    }

    @Override
    public boolean handle(Throwable exception) {
        if (super.handle(exception)) {
            return true;
        }
        if (exception instanceof WorkflowException) {
            ((WorkflowException)exception).convert();
        } else {
            if (pass.contains(exception.getClass().getName())) {
                return false;
            }
            if (!ignored.contains(exception.getClass().getName())) {
                log.log((Priority)Level.ERROR, (Object)"Exception while request", exception);
                FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, exception.getClass().getSimpleName(), null));
            }
        }
        return true;
    }
}

