/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.extensions;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.api.WriteComponent;
import com.intersult.jsf.util.DeferredResponseWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

public class ExtResponseWriter
extends ResponseWriterWrapper {
    private ResponseWriter wrapped;
    private Stack<Entry> stack = new Stack();
    private Set<String> written = new HashSet<String>();

    public ExtResponseWriter(ResponseWriter wrapped) {
        this.wrapped = wrapped;
    }

    public static ExtResponseWriter getCurrentInstance(ResponseWriter responseWriter) {
        return Jsf.unwrap(responseWriter, ExtResponseWriter.class);
    }

    public static DeferredResponseWriter getEndElementWriter() {
        return ExtResponseWriter.getEndElementWriter(FacesContext.getCurrentInstance().getResponseWriter());
    }

    public static DeferredResponseWriter getEndElementWriter(ResponseWriter responseWriter) {
        ExtResponseWriter extResponseWriter = ExtResponseWriter.getCurrentInstance(responseWriter);
        Entry entry = extResponseWriter.stack.peek();
        if (entry.getEndElementWriter() == null) {
            entry.setEndElementWriter(new DeferredResponseWriter(extResponseWriter.wrapped));
        }
        return entry.getEndElementWriter();
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        super.startElement(name, component);
        Entry entry = new Entry();
        if (component != null && this.written.add(component.getClientId())) {
            entry.setComponent(component);
            this.callStartElement(component);
        }
        this.stack.push(entry);
        if ("head".equals(name)) {
            super.startElement("meta", null);
            super.writeAttribute("http-equiv", (Object)"X-UA-Compatible", null);
            super.writeAttribute("content", (Object)"IE=9; IE=8", null);
            super.endElement("meta");
        }
    }

    public void endElement(String name) throws IOException {
        Entry entry;
        Entry entry2 = entry = this.stack.isEmpty() ? null : this.stack.pop();
        if (entry != null && entry.getComponent() != null) {
            this.callEndElement(entry.getComponent());
        }
        super.endElement(name);
        if (entry != null) {
            this.writeEndElement(entry.getEndElementWriter());
        }
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        ResponseWriter responseWriter = this.wrapped.cloneWithWriter(writer);
        return new ExtResponseWriter(responseWriter);
    }

    private void callStartElement(UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof WriteComponent) || !child.isRendered()) continue;
            ((WriteComponent)child).startElement(this.wrapped, component);
        }
    }

    private void callEndElement(UIComponent component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof WriteComponent) || !child.isRendered()) continue;
            ((WriteComponent)child).endElement(this.wrapped, component);
        }
    }

    private void writeEndElement(DeferredResponseWriter endElementWriter) throws IOException {
        if (endElementWriter != null) {
            endElementWriter.writeTo((Writer)this.wrapped);
        }
    }

    public static class Entry {
        private UIComponent component;
        private DeferredResponseWriter endElementWriter;

        public UIComponent getComponent() {
            return this.component;
        }

        public void setComponent(UIComponent component) {
            this.component = component;
        }

        public DeferredResponseWriter getEndElementWriter() {
            return this.endElementWriter;
        }

        public void setEndElementWriter(DeferredResponseWriter endElementWriter) {
            this.endElementWriter = endElementWriter;
        }
    }
}

