/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.extensions;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.wrapper.ResponseStateManagerWrapper;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ServerSideStateHelper;
import com.sun.faces.spi.SerializationProvider;
import com.sun.faces.spi.SerializationProviderFactory;
import com.sun.faces.util.RequestStateManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

public class ExtResponseStateManager
extends ResponseStateManagerWrapper {
    private WebConfiguration webConfig;
    private SerializationProvider serialProvider;
    private boolean compressViewState;
    private String stateMode;
    private boolean serializeState;

    public ExtResponseStateManager(ResponseStateManager wrapped) {
        super(wrapped);
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        this.webConfig = WebConfiguration.getInstance((ExternalContext)externalContext);
        this.serialProvider = SerializationProviderFactory.createInstance((ExternalContext)externalContext);
        this.compressViewState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CompressViewState);
        this.stateMode = this.webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod);
        this.serializeState = this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerStateDeprecated) || this.webConfig.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SerializeServerState);
    }

    @Override
    public boolean isPostback(FacesContext context) {
        String viewState;
        if (Jsf.isUseFlash() && (viewState = (String)context.getExternalContext().getFlash().get((Object)"javax.faces.ViewState")) != null) {
            return true;
        }
        return super.isPostback(context);
    }

    @Override
    public Object getState(FacesContext context, String viewId) {
        if ("client".equals(this.stateMode) || !Jsf.isUseFlash()) {
            return super.getState(context, viewId);
        }
        Object state = RequestStateManager.get((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE");
        if (state == null && (state = this.getStateInternal(context, viewId)) != null) {
            RequestStateManager.set((FacesContext)context, (String)"com.sun.faces.FACES_VIEW_STATE", (Object)state);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getStateInternal(FacesContext context, String viewId) {
        String compoundId = (String)context.getExternalContext().getRequestParameterMap().get("javax.faces.ViewState");
        if (compoundId == null || "".equals(compoundId)) {
            compoundId = (String)context.getExternalContext().getFlash().remove((Object)"javax.faces.ViewState");
        }
        if (compoundId == null || "".equals(compoundId)) {
            return null;
        }
        if ("stateless".equals(compoundId)) {
            return "stateless";
        }
        int sep = compoundId.indexOf(58);
        assert (sep != -1);
        assert (sep < compoundId.length());
        String idInLogicalMap = compoundId.substring(0, sep);
        String idInActualMap = compoundId.substring(sep + 1);
        ExternalContext externalCtx = context.getExternalContext();
        Object sessionObj = externalCtx.getSession(false);
        if (sessionObj == null) {
            return null;
        }
        Object object = sessionObj;
        synchronized (object) {
            Map actualMap;
            Map logicalMap = (Map)externalCtx.getSessionMap().get(ServerSideStateHelper.LOGICAL_VIEW_MAP);
            if (logicalMap != null && (actualMap = (Map)logicalMap.get(idInLogicalMap)) != null) {
                RequestStateManager.set((FacesContext)context, (String)"com.sun.faces.logicalViewMap", (Object)idInLogicalMap);
                Object[] state = (Object[])actualMap.get(idInActualMap);
                Object[] restoredState = new Object[]{state[0], state[1]};
                if (state != null) {
                    RequestStateManager.set((FacesContext)context, (String)"com.sun.faces.actualViewMap", (Object)idInActualMap);
                    if (state.length == 2 && state[1] != null) {
                        restoredState[1] = this.handleRestoreState(state[1]);
                    }
                }
                return restoredState;
            }
        }
        return null;
    }

    protected Object handleRestoreState(Object state) {
        if (this.serializeState) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])state);
            ObjectInputStream ois = null;
            try {
                ois = this.serialProvider.createObjectInputStream(this.compressViewState ? new GZIPInputStream((InputStream)bais, 1024) : bais);
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
        return state;
    }
}

