/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.extensions;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.extensions.ExtFacesContext;
import com.intersult.jsf.multipart.MultipartRequest;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExtFacesContextFactory
extends FacesContextFactory {
    private FacesContextFactory wrapped;

    public ExtFacesContextFactory(FacesContextFactory wrapped) {
        this.wrapped = wrapped;
    }

    public FacesContextFactory getWrapped() {
        return this.wrapped;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        ExtFacesContext extContext;
        FacesContext parent;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!httpResponse.isCommitted() && ExtFacesContextFactory.isMultipart(httpRequest)) {
            request = new MultipartRequest(httpRequest);
        }
        if ((parent = FacesContext.getCurrentInstance()) != null && (extContext = Jsf.unwrap(parent, ExtFacesContext.class)) != null && extContext.getState() == ExtFacesContext.State.FILTER_BEFORE) {
            extContext.update(httpRequest, httpResponse);
            extContext.setState(ExtFacesContext.State.SERVLET_FILTERED);
            return extContext;
        }
        FacesContext facesContext = this.wrapped.getFacesContext(context, request, response, lifecycle);
        return new ExtFacesContext(facesContext, parent, lifecycle, ExtFacesContext.State.SERVLET_STANDALONE);
    }

    public static boolean isMultipart(HttpServletRequest httpRequest) {
        String contentType = httpRequest.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/form-data");
    }
}

