/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.extensions;

import com.intersult.jsf.error.PageError;
import com.intersult.jsf.navigation.Navigation;
import com.intersult.jsf.util.java.ClassUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import org.apache.log4j.Logger;

public class ExtExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger log = Logger.getLogger(ExtExceptionHandler.class);
    public static final String FROM_ACTION = "EXCEPTION";
    private ExceptionHandler wrapped;
    private Map<Class<?>, NavigationCase> exceptionMap;

    public ExtExceptionHandler(ExceptionHandler wrapped) {
        this.wrapped = wrapped;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public Map<Class<?>, NavigationCase> getExceptionMap() {
        if (this.exceptionMap == null) {
            this.exceptionMap = new LinkedHashMap();
            FacesContext context = FacesContext.getCurrentInstance();
            ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)context.getApplication().getNavigationHandler();
            for (Set navigationCases : navigationHandler.getNavigationCases().values()) {
                for (NavigationCase navigationCase : navigationCases) {
                    Class<?> type = ClassUtils.forName(navigationCase.getFromOutcome());
                    if (type == null || !Throwable.class.isAssignableFrom(type)) continue;
                    this.exceptionMap.put(type, navigationCase);
                }
            }
        }
        return this.exceptionMap;
    }

    public final void handle() throws FacesException {
        Iterator iterator = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iterator.hasNext()) {
            Throwable exception;
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)iterator.next();
            for (exception = event.getContext().getException(); exception.getCause() != null && exception.getCause() != exception; exception = exception.getCause()) {
            }
            if (!this.handle(exception)) continue;
            iterator.remove();
        }
        this.wrapped.handle();
    }

    public boolean handle(Throwable exception) {
        if (exception instanceof ViewExpiredException) {
            Navigation.navigate().redirect();
            return true;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null || context.getPartialViewContext().isAjaxRequest()) {
            return false;
        }
        for (Map.Entry<Class<?>, NavigationCase> entry : this.getExceptionMap().entrySet()) {
            if (!entry.getKey().isInstance(exception)) continue;
            log.info((Object)"Handled exception navigation", exception);
            NavigationHandler navigationHandler = context.getApplication().getNavigationHandler();
            navigationHandler.handleNavigation(context, null, entry.getValue().getToViewId(context));
            PageError.instance().error(exception, Navigation.getViewId());
            return true;
        }
        return false;
    }
}

