/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.extensions;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.Scopes;
import com.intersult.jsf.component.scope.ScopeComponent;
import com.intersult.jsf.component.scope.ScopeHandler;
import com.intersult.jsf.extensions.ExtTag;
import com.intersult.jsf.extensions.ExtValueExpression;
import com.intersult.jsf.view.ResourceType;
import com.intersult.jsf.wrapper.ComponentHandlerWrapper;
import com.sun.faces.facelets.el.TagValueExpression;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;

public class ExtComponentHandler
extends ComponentHandlerWrapper {
    public ExtComponentHandler(ComponentHandler wrapped) {
        super(wrapped);
    }

    @Override
    public void applyNextHandler(FaceletContext ctx, UIComponent component) throws IOException, FacesException, ELException {
        ExtTag.push(component);
        this.wrapped.applyNextHandler(ctx, component);
        if ("javax.faces.Body".equals(component.getRendererType())) {
            UIComponent scopesComponent = component.findComponent("scope-container");
            if (scopesComponent == null) {
                scopesComponent = ctx.getFacesContext().getApplication().createComponent("intersult.Scopes");
                scopesComponent.setId("scope-container");
                component.getChildren().add(scopesComponent);
            }
            this.applyScopeHandler(ctx, scopesComponent);
            this.applyPrimefacesResources(ctx.getFacesContext(), component);
        }
        ExtTag.pop();
    }

    public void applyScopeHandler(FaceletContext ctx, UIComponent component) {
        String scopeId;
        FacesContext context = ctx.getFacesContext();
        Scopes scopes = Scopes.instance();
        for (Scopes.Scope scope : scopes.getList()) {
            Object load;
            if (Boolean.TRUE.equals(scope.get("scope.bind"))) continue;
            scopeId = (String)scope.get("id");
            String viewId = (String)scope.get("scope.viewId");
            String library = (String)scope.get("scope.library");
            ScopeComponent scopeComponent = (ScopeComponent)context.getViewRoot().findComponent(scopeId);
            if (scopeComponent == null) {
                scopeComponent = (ScopeComponent)context.getApplication().createComponent("intersult.Scope");
                scopeComponent.setId(scopeId);
                component.getChildren().add(scopeComponent);
            }
            if (viewId != null) {
                Object previous = scope.push();
                try {
                    ScopeHandler.includeFacelet(ctx, (UIComponent)scopeComponent, viewId, library);
                }
                catch (Exception exception) {
                    Scopes.instance().unload(scopeId);
                    throw new FacesException("Error loading scope with viewId '" + viewId + "'", (Throwable)exception);
                }
                scope.pop(previous);
            }
            if ((load = scope.remove("scope.load")) == null) continue;
            if (context.getPartialViewContext().isPartialRequest()) {
                if (Boolean.TRUE.equals(load)) {
                    Jsf.appendClientId(scopeId);
                } else {
                    Jsf.renderClientId(scopeId);
                }
            }
            scopeComponent.processLoad();
        }
        Iterator iterator = component.getChildren().iterator();
        while (iterator.hasNext()) {
            UIComponent scopeComponent = (UIComponent)iterator.next();
            scopeId = scopeComponent.getId();
            if (scopes.get(scopeId) != null) continue;
            iterator.remove();
        }
    }

    public void applyPrimefacesResources(FacesContext context, UIComponent body) {
        if (!Jsf.isPrimefaces()) {
            return;
        }
        UIComponent stylesheet = body.findComponent(Jsf.getResourceId("primefaces.css", "css"));
        if (stylesheet != null) {
            return;
        }
        body.getChildren().add(Jsf.createResource(context, ResourceType.STYLESHEET, "primefaces.css", "css"));
        body.getChildren().add(Jsf.createResource(context, ResourceType.SCRIPT, "util.js", "ext-js"));
        body.getChildren().add(Jsf.createResource(context, ResourceType.SCRIPT, "primefaces.js", "ext-js"));
    }

    @Override
    public void setAttributes(FaceletContext ctx, Object instance) {
        Map<String, Object> bindings;
        this.wrapped.setAttributes(ctx, instance);
        if (instance != null && instance instanceof UIComponent && (bindings = Jsf.getBindings((UIComponent)instance)) != null) {
            for (String binding : bindings.keySet()) {
                Object object = bindings.get(binding);
                if (object == null || !(object instanceof TagValueExpression)) continue;
                object = new ExtValueExpression((ValueExpression)object);
                bindings.put(binding, object);
            }
        }
    }
}

