/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.event;

import com.intersult.jsf.event.Event;
import com.intersult.jsf.event.EventException;
import com.intersult.jsf.event.EventListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class WeakMethodListener
extends EventListener {
    private static final long serialVersionUID = 1L;
    private String key;
    private String event;
    private WeakReference<Object> objectReference;
    private String methodName;
    private Class<?>[] parameterTypes;
    private transient Method method;
    private int priority;

    public WeakMethodListener(String event, int priority, Object object, Method method) {
        this.event = event;
        this.objectReference = new WeakReference<Object>(object);
        this.priority = priority;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.method = method;
        this.key = event + "." + System.identityHashCode(object) + "." + method.toString();
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public Object getObject() {
        Object object = this.objectReference.get();
        if (object == null) {
            Event event = Event.instance();
            if (event == null) {
                return null;
            }
            event.remove(this);
        }
        return object;
    }

    @Override
    public boolean invoke(Object ... arguments) {
        try {
            Method method = this.getMethod();
            Object result = method.getParameterTypes().length == 0 ? method.invoke(this.getObject(), new Object[0]) : method.invoke(this.getObject(), arguments);
            return result == null ? false : (Boolean)result;
        }
        catch (Exception exception) {
            throw new EventException(exception);
        }
    }

    public Method getMethod() {
        if (this.method == null) {
            try {
                this.method = this.getObject().getClass().getMethod(this.methodName, this.parameterTypes);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.method;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WeakMethodListener other = (WeakMethodListener)obj;
        return this.key.equals(other.key);
    }

    public String toString() {
        return this.key;
    }
}

