/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.event;

import com.intersult.jsf.event.EventListener;
import com.intersult.jsf.event.Listener;
import com.intersult.jsf.event.MethodListener;
import com.intersult.jsf.util.java.AnnotationUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class Router
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EVENT_POST_CONSTRUCT = "event.post_construct";
    public static final String EVENT_PRE_DESTROY = "event.faces.pre_destroy";
    public static final String EVENT = "event.event";
    public static final int PRIORITY_VERY_LOW = -20;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_HIGH = 10;
    public static final int PRIORITY_VERY_HIGH = 20;
    private Map<String, SortedSet<EventListener>> listenerMap = new ConcurrentHashMap<String, SortedSet<EventListener>>();

    public void addObject(Object object) {
        List<Method> methods = AnnotationUtils.getMethods(object.getClass(), Listener.class);
        for (Method method : methods) {
            String[] eventNames;
            Listener listener = method.getAnnotation(Listener.class);
            int priority = listener.priority();
            for (String eventName : eventNames = listener.value()) {
                this.add(new MethodListener(eventName, priority, object, method));
            }
        }
        this.raise(EVENT_POST_CONSTRUCT, object);
    }

    public void removeObject(Object object) {
        this.raise(EVENT_PRE_DESTROY, object);
        List<Method> methods = AnnotationUtils.getMethods(object.getClass(), Listener.class);
        for (Method method : methods) {
            String[] eventNames;
            Listener listener = method.getAnnotation(Listener.class);
            int priority = listener.priority();
            for (String eventName : eventNames = listener.value()) {
                this.remove(new MethodListener(eventName, priority, object, method));
            }
        }
    }

    public void add(EventListener listener) {
        String event = listener.getEvent();
        SortedSet<EventListener> listeners = this.listenerMap.get(event);
        if (listeners == null) {
            listeners = new TreeSet<EventListener>();
            this.listenerMap.put(event, listeners);
        }
        listeners.remove(listener);
        listeners.add(listener);
    }

    public void remove(EventListener listener) {
        String event = listener.getEvent();
        SortedSet<EventListener> listeners = this.listenerMap.get(event);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public boolean raise(String event, Object ... arguments) {
        if (this.raise(this.listenerMap.get(EVENT), event, arguments)) {
            return true;
        }
        return this.raise(this.listenerMap.get(event), arguments);
    }

    private boolean raise(SortedSet<EventListener> listeners, Object ... arguments) {
        if (listeners != null) {
            for (EventListener listener : listeners) {
                if (!listener.invoke(arguments)) continue;
                return true;
            }
        }
        return false;
    }
}

