/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.event;

import com.intersult.jsf.event.EventException;
import com.intersult.jsf.event.EventListener;
import com.intersult.jsf.util.java.ClassUtils;
import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodListener
extends EventListener {
    private static final long serialVersionUID = 1L;
    private String event;
    private Object object;
    private String methodName;
    private Class<?>[] parameterTypes;
    private transient Method method;
    private int priority;

    public MethodListener(String event, int priority, Object object, Method method) {
        this.event = event;
        this.object = object;
        this.priority = priority;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.method = method;
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean invoke(Object ... arguments) {
        try {
            Method method = this.getMethod();
            Object result = method.getParameterTypes().length == 0 ? method.invoke(this.object, new Object[0]) : method.invoke(this.object, arguments);
            return result == null ? false : (Boolean)result;
        }
        catch (Exception exception) {
            throw new EventException(exception);
        }
    }

    public Method getMethod() {
        if (this.method == null) {
            try {
                this.method = this.object.getClass().getMethod(this.methodName, this.parameterTypes);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return this.method;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.methodName == null ? 0 : this.methodName.hashCode());
        result = 31 * result + (this.object == null ? 0 : ClassUtils.unproxy(this.object).hashCode());
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodListener other = (MethodListener)obj;
        if (this.methodName == null ? other.methodName != null : !this.methodName.equals(other.methodName)) {
            return false;
        }
        if (this.object == null ? other.object != null : !ClassUtils.unproxy(this.object).equals(ClassUtils.unproxy(other.object))) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public String toString() {
        return this.getMethod().toString();
    }
}

