/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.event;

import com.intersult.jsf.event.EventListener;
import com.intersult.jsf.event.Listener;
import com.intersult.jsf.event.MethodExpressionListener;
import com.intersult.jsf.event.MethodListener;
import com.intersult.jsf.util.java.AnnotationUtils;
import com.sun.faces.config.InitFacesContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

public class Event
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EVENT_POST_CONSTRUCT = "javax.faces.post_construct";
    public static final String EVENT_PRE_DESTROY = "javax.faces.pre_destroy";
    public static final String EVENT_EVENT = "javax.faces.event";
    public static final String SESSION_ATTRIBUTE = "javax.faces.EVENT";
    public static final String CONTEXT_ATTRIBUTE = "javax.faces.EVENTS";
    public static final int PRIORITY_VERY_LOW = -20;
    public static final int PRIORITY_LOW = -10;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_HIGH = 10;
    public static final int PRIORITY_VERY_HIGH = 20;
    public static boolean injection;
    private Map<String, Set<EventListener>> listenerMap = new ConcurrentHashMap<String, Set<EventListener>>();

    public Event() {
        this.add(new MethodExpressionListener(EVENT_EVENT, 0, "#{update.event}", String.class, Object[].class));
    }

    public static Event instance() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null || context instanceof InitFacesContext) {
            return null;
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext == null) {
            return null;
        }
        Event event = (Event)externalContext.getSessionMap().get(SESSION_ATTRIBUTE);
        if (event == null) {
            event = new Event();
            externalContext.getSessionMap().put(SESSION_ATTRIBUTE, event);
        }
        return event;
    }

    public static boolean isInjection() {
        return injection;
    }

    public static void setInjection(boolean injection) {
        Event.injection = injection;
    }

    public static void addObject(Object object) {
        Event event = Event.instance();
        if (event != null) {
            List<Method> methods = AnnotationUtils.getMethods(object.getClass(), Listener.class);
            for (Method method : methods) {
                String[] eventNames;
                Listener listener = method.getAnnotation(Listener.class);
                int priority = listener.priority();
                for (String eventName : eventNames = listener.value()) {
                    event.add(new MethodListener(eventName, priority, object, method));
                }
            }
            event.raise(EVENT_POST_CONSTRUCT, object);
        }
    }

    public static void removeObject(Object object) {
        Event event = Event.instance();
        if (event != null) {
            event.raise(EVENT_PRE_DESTROY, object);
            List<Method> methods = AnnotationUtils.getMethods(object.getClass(), Listener.class);
            for (Method method : methods) {
                String[] eventNames;
                Listener listener = method.getAnnotation(Listener.class);
                int priority = listener.priority();
                for (String eventName : eventNames = listener.value()) {
                    event.remove(new MethodListener(eventName, priority, object, method));
                }
            }
        }
    }

    public synchronized void add(EventListener listener) {
        String event = listener.getEvent();
        Set<EventListener> listeners = this.listenerMap.get(event);
        if (listeners == null) {
            listeners = Collections.synchronizedSet(new TreeSet());
            this.listenerMap.put(event, listeners);
        }
        listeners.remove(listener);
        listeners.add(listener);
    }

    public synchronized void remove(EventListener listener) {
        String event = listener.getEvent();
        Set<EventListener> listeners = this.listenerMap.get(event);
        if (listeners != null) {
            listeners.remove(listener);
        }
    }

    public synchronized void raise(String event, Object ... arguments) {
        this.raise(this.listenerMap.get(EVENT_EVENT), event, arguments);
        this.raise(this.listenerMap.get(event), arguments);
    }

    private void raise(Set<EventListener> listeners, Object ... arguments) {
        if (listeners != null) {
            for (EventListener listener : listeners) {
                this.getInvocations().add(new Invocation(listener, arguments));
            }
        }
    }

    public void processEvents() {
        Set<Invocation> invocations = this.clearInvocations();
        if (invocations != null) {
            for (Invocation invocation : invocations) {
                invocation.invoke();
            }
        }
    }

    public Set<Invocation> getInvocations() {
        Map attributes = FacesContext.getCurrentInstance().getAttributes();
        LinkedHashSet invocations = (LinkedHashSet)attributes.get(CONTEXT_ATTRIBUTE);
        if (invocations == null) {
            invocations = new LinkedHashSet();
            attributes.put(CONTEXT_ATTRIBUTE, invocations);
        }
        return invocations;
    }

    private synchronized Set<Invocation> clearInvocations() {
        return (Set)FacesContext.getCurrentInstance().getAttributes().remove(CONTEXT_ATTRIBUTE);
    }

    public static final class Invocation {
        private EventListener listener;
        private Object[] arguments;

        public Invocation(EventListener listener, Object ... arguments) {
            this.listener = listener;
            this.arguments = arguments;
        }

        public EventListener getListener() {
            return this.listener;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public void invoke() {
            this.listener.invoke(this.arguments);
        }

        public String toString() {
            return this.listener.toString();
        }
    }
}

