/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.el;

import com.intersult.jsf.Jsf;
import com.intersult.jsf.util.java.ClassUtils;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.apache.log4j.Logger;

public class Interpolator {
    private static Logger log = Logger.getLogger(Interpolator.class);
    public static final Pattern PATTERN_EXPRESSION = Pattern.compile("\\#\\{.*?\\}");

    public static String interpolate(String text) {
        return Interpolator.interpolate(FacesContext.getCurrentInstance().getELContext(), text);
    }

    public static String interpolate(ELContext elContext, String text) {
        StringBuilder buffer = new StringBuilder();
        Matcher matcher = PATTERN_EXPRESSION.matcher(text);
        int index = 0;
        while (matcher.find()) {
            if (index > matcher.start()) {
                index = matcher.start();
            }
            buffer.append(text.substring(index, matcher.start()));
            String expression = matcher.group();
            try {
                Object value = Interpolator.evaluate(elContext, expression, Object.class);
                buffer.append(value);
            }
            catch (Exception exception) {
                log.error((Object)("Error evaluating expression '" + expression + "'"), (Throwable)exception);
                buffer.append(expression);
            }
            index = matcher.end();
        }
        buffer.append(text.substring(index));
        return buffer.toString();
    }

    public static <T> T evaluate(ELContext elContext, String expression, Class<T> type) {
        ValueExpression valueExpression = Interpolator.create(elContext, expression, type);
        return (T)valueExpression.getValue(elContext);
    }

    public static ValueExpression create(ELContext elContext, String expression, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueExpression valueExpression = context.getApplication().getExpressionFactory().createValueExpression(elContext, expression, type);
        return valueExpression;
    }

    public static <T> T evaluate(String attribute, Class<T> type) {
        return Interpolator.evaluate(attribute, type, null);
    }

    public static <T> T evaluate(String attribute, Class<T> type, T defaultValue) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent component = UIComponent.getCurrentComponent((FacesContext)context);
        return Interpolator.evaluate(context.getELContext(), component, attribute, type, defaultValue);
    }

    public static <T> T evaluate(ELContext elContext, UIComponent component, String attribute, Class<T> type) {
        return Interpolator.evaluate(elContext, component, attribute, type, null);
    }

    public static <T> T evaluate(ELContext elContext, UIComponent component, String attribute, Class<T> type, T defaultValue) {
        ValueExpression expression = component.getValueExpression(attribute);
        if (expression == null) {
            return defaultValue;
        }
        Object value = expression.getValue(elContext);
        return Interpolator.coerce(value, type);
    }

    public static MethodExpression createMethodExpression(String expression, Class<?> returnType, Class<?> ... paramTypes) {
        FacesContext context = FacesContext.getCurrentInstance();
        MethodExpression methodExpression = context.getApplication().getExpressionFactory().createMethodExpression(context.getELContext(), expression, returnType, (Class[])paramTypes);
        return methodExpression;
    }

    public static ValueExpression createValueExpression(String expression, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueExpression valueExpression = context.getApplication().getExpressionFactory().createValueExpression(context.getELContext(), expression, type);
        return valueExpression;
    }

    public static ValueExpression createLiteral(Object instance) {
        return Interpolator.createLiteral(instance, instance == null ? Object.class : instance.getClass());
    }

    public static ValueExpression createLiteral(Object instance, Class<?> type) {
        FacesContext context = FacesContext.getCurrentInstance();
        ValueExpression literal = context.getApplication().getExpressionFactory().createValueExpression(instance, type);
        return literal;
    }

    public static <Type> Type coerce(Object object, Class<Type> type) {
        if (object == null) {
            return null;
        }
        Object result = FacesContext.getCurrentInstance().getApplication().getExpressionFactory().coerceToType(object, type);
        return (Type)result;
    }

    public static ValueExpression setVariable(String name, Object value) {
        FacesContext context = FacesContext.getCurrentInstance();
        VariableMapper variableMapper = context.getELContext().getVariableMapper();
        ValueExpression literal = Interpolator.createLiteral(value);
        ValueExpression origExpression = variableMapper.setVariable(name, literal);
        return origExpression;
    }

    public static void restoreVariable(String name, ValueExpression valueExpression) {
        Interpolator.restoreVariable(FacesContext.getCurrentInstance(), name, valueExpression);
    }

    public static void restoreVariable(FacesContext context, String name, ValueExpression valueExpression) {
        VariableMapper variableMapper = context.getELContext().getVariableMapper();
        variableMapper.setVariable(name, valueExpression);
    }

    public static <Type> Type get(String expression, Class<Type> type) {
        ValueExpression valueExpression = Interpolator.createValueExpression(expression, type);
        return (Type)valueExpression.getValue(FacesContext.getCurrentInstance().getELContext());
    }

    public static <Type> void set(String expression, Class<Type> type, Type value) {
        ValueExpression valueExpression = Interpolator.createValueExpression(expression, type);
        valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), value);
    }

    public static <Type> Type action(String expression, Class<Type> returnType, Object ... params) {
        MethodExpression methodExpression = Interpolator.createMethodExpression(expression, returnType, ClassUtils.getTypes(params));
        return (Type)methodExpression.invoke(FacesContext.getCurrentInstance().getELContext(), params);
    }

    public static MethodExpression createMethodExpression(Method method) {
        String beanName = Jsf.getBeanName(method.getDeclaringClass());
        String expression = "#{" + beanName + "." + method.getName() + "}";
        return Interpolator.createMethodExpression(expression, method.getReturnType(), method.getParameterTypes());
    }

    public static String convert(Object value) {
        if (value == null) {
            return null;
        }
        Converter converter = Interpolator.converterFor(value.getClass());
        if (converter == null) {
            return Interpolator.coerce(value, String.class);
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return converter.getAsString(context, (UIComponent)context.getViewRoot(), value);
    }

    public static Converter converterFor(Class<?> type) {
        if (type == null) {
            return null;
        }
        return FacesContext.getCurrentInstance().getApplication().createConverter(type);
    }
}

