/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.el;

import com.intersult.jsf.el.ExtMethodExpression;
import com.intersult.jsf.el.MethodReference;
import com.intersult.jsf.el.ValueReference;
import com.intersult.jsf.util.java.ClassUtils;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.el.CompositeComponentExpressionHolder;

public class ExpressionAnalyzer {
    public static ValueReference getReference(ValueExpression expression, ELContext elContext) {
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        try {
            ValueExpression compositeExpression;
            Object base;
            expression.setValue(ExpressionAnalyzer.decorateELContext(elContext, resolver), null);
            ValueReference reference = resolver.getValueReference();
            if (reference != null && (base = reference.getBase()) instanceof CompositeComponentExpressionHolder && (compositeExpression = ((CompositeComponentExpressionHolder)base).getExpression((String)reference.getProperty())) != null) {
                reference = ExpressionAnalyzer.getReference(compositeExpression, elContext);
            }
            return reference;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static MethodReference getReference(MethodExpression expression, ELContext elContext) {
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        try {
            MethodInfo methodInfo = expression.getMethodInfo(ExpressionAnalyzer.decorateELContext(elContext, resolver));
            if (methodInfo instanceof MethodReference) {
                return (MethodReference)methodInfo;
            }
            MethodReference reference = resolver.getMethodReference(methodInfo);
            return reference;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isExpressionValid(ELContext elContext, MethodExpression expression) {
        try {
            expression.getMethodInfo(elContext);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static MethodExpression toMethodExpression(ELContext elContext, ValueExpression expression) {
        InterceptingResolver resolver = new InterceptingResolver(elContext.getELResolver());
        try {
            expression.getValue(ExpressionAnalyzer.decorateELContext(elContext, resolver));
            return new ExtMethodExpression(resolver.getBase(), resolver.getMethod(), expression.getExpressionString());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static ELContext decorateELContext(final ELContext context, final ELResolver resolver) {
        return new ELContext(){

            public ELResolver getELResolver() {
                return resolver;
            }

            public Object getContext(Class key) {
                return context.getContext(key);
            }

            public Locale getLocale() {
                return context.getLocale();
            }

            public boolean isPropertyResolved() {
                return context.isPropertyResolved();
            }

            public void putContext(Class key, Object contextObject) {
                context.putContext(key, contextObject);
            }

            public void setLocale(Locale locale) {
                context.setLocale(locale);
            }

            public void setPropertyResolved(boolean resolved) {
                context.setPropertyResolved(resolved);
            }

            public FunctionMapper getFunctionMapper() {
                return context.getFunctionMapper();
            }

            public VariableMapper getVariableMapper() {
                return context.getVariableMapper();
            }
        };
    }

    private static class InterceptingResolver
    extends ELResolver {
        private ELResolver delegate;
        private ValueReference valueReference;
        private Object base;
        private Method method;

        public InterceptingResolver(ELResolver delegate) {
            this.delegate = delegate;
        }

        public ValueReference getValueReference() {
            return this.valueReference;
        }

        public Object getBase() {
            return this.base;
        }

        public Method getMethod() {
            return this.method;
        }

        public MethodReference getMethodReference(MethodInfo methodInfo) throws Exception {
            Method method = this.base.getClass().getMethod(methodInfo.getName(), methodInfo.getParamTypes());
            return new MethodReference(this.base, method);
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (base != null && property != null) {
                context.setPropertyResolved(true);
                this.valueReference = new ValueReference(ClassUtils.unproxy(base), property.toString());
            }
        }

        public Object getValue(ELContext context, Object base, Object property) {
            try {
                Object value = this.delegate.getValue(context, base, property);
                if (context.isPropertyResolved()) {
                    this.base = value;
                }
                return value;
            }
            catch (Exception exception) {
                if (base != null) {
                    this.method = ClassUtils.getMethod(base.getClass(), property.toString());
                }
                return null;
            }
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            return this.delegate.getType(context, base, property);
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            return this.delegate.isReadOnly(context, base, property);
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            return this.delegate.getFeatureDescriptors(context, base);
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            return this.delegate.getCommonPropertyType(context, base);
        }

        public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
            return this.delegate.invoke(context, base, method, (Class[])paramTypes, params);
        }
    }
}

