/*
 * Decompiled with CFR 0.152.
 */
package com.intersult.jsf.el;

import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;

public class DeferredValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private String name;
    private Object value;
    private ValueExpression orig;

    public DeferredValueExpression(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public static DeferredValueExpression push(ELContext context, String name, Object value) {
        DeferredValueExpression expression = new DeferredValueExpression(name, value);
        expression.setOrig(context.getVariableMapper().setVariable(name, (ValueExpression)expression));
        return expression;
    }

    public static <Type> void pop(ELContext context, String name) {
        context.getVariableMapper().setVariable(name, ((DeferredValueExpression)context.getVariableMapper().resolveVariable(name)).getOrig());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ValueExpression getOrig() {
        return this.orig;
    }

    public void setOrig(ValueExpression orig) {
        this.orig = orig;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue(ELContext context) {
        return this.value;
    }

    public void setValue(ELContext context, Object value) {
        throw new PropertyNotWritableException();
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public Class<?> getType(ELContext context) {
        Object value = this.getValue(context);
        return value == null ? this.getExpectedType() : value.getClass();
    }

    public Class<?> getExpectedType() {
        return Object.class;
    }

    public String getExpressionString() {
        return "#{" + this.name + "}";
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DeferredValueExpression)) {
            return false;
        }
        return this.name.equals(((DeferredValueExpression)((Object)object)).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getExpressionString() + " = " + this.getValue();
    }
}

